/*+
 * VOID tfrclr(keywrd)
 *     TEXT/COUNT *keywrd;
 *
 * Description  : Routine to clear screen and field copy record(s)
 *
 * Arguments    : keywrd  = STRING or INTEGER keyword info:
 *                           STRING containing one of the following keywords:
 *                           'ALL'  - clear fix, display-only and update field
 *                           'VAR'  - clear display-only and update fields
 *                           'DON'  - clear display-only fields
 *                           'UPD'  - clear update fields
 *                           INTEGER row number from which the screen has to
 *                                   be cleared
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 * Version      : V1.1      Date : 22-JUL-83
 *
 * Module name  : TFRCLR.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *                R.Beetz              V1.1
 *  description : clear DON-fields without attributes
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrclr.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrclr(keywrd)
    TEXT *keywrd;

    {
    VOID scvtlu();

    IMPORT TFRCOM t;

#include <dondef.h>
#include <upddef.h>

    UNION
        {
        TEXT  key[4];
        COUNT nrow;
        } a1;

    LOCAL TEXT  cc[] = "+$",
                lf[] = "\n";

    COUNT ikey, *pf, i, j, irec;

    pf = &t.frec;
/*
 *    check keyword
 */
    cpybuf(&a1, keywrd, 3);
    a1.key[3] = NULL;
    ikey = 0;
    scvtlu(&a1);
    if(cmpstr(&a1, "DON"))
        {
        ikey = 1;
        }
    else if(cmpstr(&a1, "UPD"))
        {
        ikey = 2;
        }
    else if(cmpstr(&a1, "VAR"))
        {
        ikey = 3;
        }
    else if(cmpstr(&a1, "ALL"))
        {
        a1.nrow = 1;
        }
    if(ikey == 0  && a1.nrow <= 0)
        {
        error("TFRCLR", "Invalid keyword arguement");
        }
/*
 *    clear FCR if clear update fields
 */
    if((ikey & 2) == 2  &&  t.nrfufr)
        {
        for(i = t.nrfufr; i <= t.nrlufr; ++i)
            {
            tfrru(i, "ALL");
            for(j = pf->npfcr;
                j < pf->npfcr+pf->lenupd-1;
                t.fcr[j] = ' ', ++j);
            if((irec = pf->nrdef))
                {
                tfrfs(&irec);
                if((j = lenstr(&t.sbuf)) < pf->lenupd)
                    {
                    cpystr(&t.fcr[pf->npfcr], &t.sbuf, NULL);
                    t.fcr[pf->npfcr+j] = ' ';
                    }
                else
                    {
                    cpybuf(&t.fcr[pf->npfcr], &t.sbuf, j);
                    }
                }
            }
        }
/*
 *    clear screen by row
 */
    if(!ikey)
        {
        swrite(t.iscr, cc, &t.homstr, NULL);
        for(i = 1; i < a1.nrow; ++i)
            {
            swrite(t.iscr, cc, lf, NULL);
            }
        swrite(t.iscr, cc, &t.natstr, &t.clrstr);
        }
    else
        {
        if((ikey & 1) == 1  &&  t.nrfdfr)
            {
            for(i = t.nrfdfr; i <= t.nrldfr; ++i)
                {
                tfrru(i, "VAR");         /* read display-only field record */
                swrite(t.iscr, cc, &pf->donesc, &t.natstr, NULL);
                rswrit(t.iscr, cc, &pf->lendon, " ");
                }
            }
/*
 *    clear error/help message
 */
        if(!t.iheflg)
            {
            swrite(t.iscr, cc, &t.herpos, &t.erlstr, NULL);
            }
/*
 *    clear update fields (backwards)
 */
        if(((ikey & 2) == 2)  &&  t.nrfufr)
            {
            for(i = t.nrlufr; i >= t.nrfufr; --i)
                {
                tfrru(i, "ALL");        /* read update field record */
                swrite(t.iscr, cc, &pf->updesc, &t.fcr[pf->npfcr], NULL);
                }
            }
        }
/*
 *    turn off help/error message flag and video attributes
 */
    t.iheflg = FALSE;
    swrite(t.iscr, cc, &t.natstr, NULL);
    }
                                                                                                                                        