/*+
 * VOID cread(unit, buf, len)
 *    COUNT  unit, len;
 *    TEXT   *buf;
 *
 * Description  : This routine reads character input on
 *                simulated fortran logical unit number.
 *
 * Arguments    : unit   = unit number to read from.
 *                text   = buffer to be filled.
 *                len    = number of bytes to receive.
 *
 * Author       : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : cread.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <fortio.h>

VOID cread(unit, buf, len)
    COUNT  unit, len;
    TEXT   *buf;

    {
    IMPORT FIO fortio[NFCHNL],
               stdin;

    --unit;
    if(fortio[unit]._fd == -1)
        {
        return(getl(&stdin, buf, len));
        }
    else
        {
        return(getl(&fortio[unit], buf, len));
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                               