	SUBROUTINE FDERIV (DERIV, X, A, NMODEL)
C
C	Exponential derivative of model function for NLFIT.
C	One or two exponentials, with or without background,
C	are modeled as follows:
C
C	    NMODEL	MODEL
C
C	      2         A(1)*EXP(A(2)*X)
C	      3         A(1)*EXP(A(2)*X)+A(3)
C	      4         A(1)*EXP(A(2)*X)+A(3)*EXP(A(4)*X)
C	      5         A(1)*EXP(A(2)*X)+A(3)*EXP(A(4)*X)+A(5)
C
	DOUBLE PRECISION DERIV(1), A(1), XX
C
	XX = X
	DERIV(1) = DEXP( A(2)*XX )
	DERIV(2) = A(1) * XX * DERIV(1)
C
	GO TO (20,30,40,50), NMODEL-1
C
   20	RETURN
C
   30	DERIV(3) = 1D0
	RETURN
C
   40	DERIV(3) = DEXP( A(4)*XX )
	DERIV(4) = A(3) * XX * DERIV(3)
	RETURN
C
   50	DERIV(5) = 1D0
	GO TO 40
C
	END
                                                                                                                                                                                                                                                                                                            