	PROGRAM KTCC
C
C	KTCC is a test program designed to display response detected from
C	a VT100 series terminal's keyboard.  Specifically, it is intended
C	to demonstrate the TCFL library's input stream filter & decode
C	routines.  KTCC must be stopped by typing ^C^C.
C
C	Link KTCC,TCFL.CSL			83/05/17
C
	IMPLICIT INTEGER (A-Z)
	BYTE STRING(81),DRCTN(3,4),SPCL(5)
	DATA DRCTN /'U','p',' ','D','w','n','R','h','t','L','f','t'/
	DATA SPCL /'b','e','i','c','d'/
C
C	Define Keyboards operational parameters
C
	CALL TTMDE(1)		!Enable lowercase input
	CALL ANSI		!Make sure VT100 understands ANSI commands
	CALL SCSUSA		!Select American-English character set
	CALL KPNM		!Define Keypad Numeric mode
	TYPE 100
  100	FORMAT(1H0,'Keypad application mode?  [Y/N]  ',$)
	ACCEPT 200,I
  200	FORMAT(A1)
	IF(I .EQ. 'Y')  CALL KPAM
	CALL RM(1)		!Reset Cursor Key Mode
	TYPE 300
  300	FORMAT(1H0,'Cursor Key mode?  [Y/N]  ',$)
	ACCEPT 200,I
	IF(I .EQ. 'Y')  CALL SM(1)
	CALL CLRALL
	GO TO 15
C
C	Demonstrate Input stream filter & decode routines
C
   10	CALL ISLEEP(0,0,1,0)		!Let user view last input
   15	CALL CUP(24,10)
	CALL OUTTZN('Press any key on the keyboard')
   20	I = LESCSQ(STRING)		!Receive & filter input from terminal
	IF(I .LT. 0)  GO TO 20		!Timeout - just wait for it
   25	CALL CLRALL
	IF(I .GT. 0)  GO TO 40
C
C	Non-Escape Sequence Input
C
	CALL CUP(12,40)
	IF(STRING(1) .LE. "40 .OR. STRING(1) .EQ. "177)  GO TO 30
	TYPE 400,STRING(1)
  400	FORMAT(1H+,A1,$)		!Display the ASCII character
	GO TO 10
   30	IF(STRING(1) .LT. "11 .OR. STRING(1) .GT. "15)  GO TO 35
	CALL SCSGRF
	TYPE 400,SPCL(STRING(1)-"10)	!Display as VT100 Graphics
	CALL SCSUSA
	GO TO 10
   35	CALL CUB
	TYPE 500,STRING(1)		!Display the Octal value
  500	FORMAT(1H+,O3,$)
	GO TO 10
C
C	Escape sequence detected
C
   40	IF(I .EQ. 2)  GO TO 60			!Any 2 char. <ESC> seq.
C
C	Detect Cursor positioning commands when Cursor Key Mode Reset
C
	IF(I .NE. 3 .OR. STRING(2) .NE. '[')  GO TO 50
	CODE = STRING(3) .AND. "77
	IF(CODE .EQ. 0 .OR. CODE .GT. 4)  GO TO 50
	CALL CUP(12,20)
	CALL PRINT('Cursor Key Mode Reset:  Cursor Key = ')
	CALL CUP(12,57)
	GO TO 70
   50	CALL CUP(12,20)
	CALL PRINT('Unrecognized Escape sequence = $')
	CALL CUP(12,52)
	CALL PRINT(STRING(2))
	GO TO 10
   60	I = KITCC(STRING(2),CODE)	!Filter & decode keypad & cursor keys
	IF(I .LT. 0)  GO TO 50
	CALL CUP(12,25)
	CALL PRINT('Command Key = ')
	CALL CUP(12,39)
	IF(I .GT. 0)  GO TO 70
	TYPE 400,CODE			!Display Keypad Numeric Commands
	GO TO 10
   70	IF(CODE .GT. 4)  GO TO 80
	TYPE 600,(DRCTN(L,CODE),L=1,3)	!Display Cursor Key Commands
  600	FORMAT(1H+,3A1,$)
	GO TO 10
   80	IF(CODE .NE. "15)  GO TO 90	!Display Keypad <ENTER> Command
	CALL PRINT('<ENTER>')
	GO TO 10
   90	TYPE 700,CODE-"17		!Display Programmable Function Cmds.
  700	FORMAT(1H+,'PF',I1,$)
	GO TO 10
	END
                                                                                                                                                              