program decus;
{								}
{								}
{	This program takes a RUNOFF .DOC file and puts it  	}
{	in a two column format ready for putting on the 	}
{	layup sheets.  The program assumes that there will 	}
{	be a title and an abstract and puts them both out 	}
{	as input and they can span the entire page width.	}
{	From then on, it uses a two column format.		}
{								}
{								}
{	There are a few limitations with this program.		}
{								}
{	1.  You have to remove the leading form feed		}
{	    from the begining of the file as well as all 	}
{	    of the form feed characters in the file.  The	}
{	    program will break the pages as required.		}
{								}
{	2.  You have to put a ^Z at the end of the file		}
{	    so that the EOF will work properly with OMSI	}
{	    PASCAL.						}
{								}
{	3.  There can be no .PAGE directives embedded 		}
{	    within the text.  That should be no problem		}
{	    because you do not want a lot of white space	}
{	    in the report anyway.				}
{								}
{	4.  If no header format is used with RUNOFF, you	}
{	    may have to put in a blank line ahead of any	}
{	    paragraphs that start on the first line of		}
{	    a page because of the eliminated form feed.		}
{								}
{	5.  Figures and tables that are wider than the		}
{	    column will have to be put full width on the	}
{	    layup sheet and will therefore have to be in	}
{	    a different file and printed separately.		}
{								}
{	6.  Input file assumed to be 'DECUS.DOC'		}
{	    Output file assumed to be 'DECUS.RPT'		}
{								}
{								}
{	Variables of concern:					}
{								}
{	dpagelength = number of lines per page on the		}
{		      input document.				}
{								}
{	dleftmargin = left margin on the output document	}
{								}
{	dcolumnwidth = widths of columns on ouput document	}
{								}
{	dpaperwidth = width of paper on output document		}
{								}
{	dfiller = number of spaces between columns		}
{								}
{	An example:						}
{								}
{	.SP 1							}
{	.PS 72,92						}
{	.LM 0							}
{	.RM 92							}
{	.C							}
{	Title							}
{	.B 1							}
{	.C							}
{	Author and where you work				}
{	.NHD							}
{	.b 3							}
{	.C							}
{	ABSTRACT						}
{	.LM 19							}
{	.RM 71							}
{	Abstract text						}
{	.LM 0							}
{	.RM 43							}
{	Text of paper						}
{		(NO .PAGE anywhere in here)			}
{								}
{								}
{	Then we set the variables as follows:			}
{								}
{	dfiller = 5;	 (number of spaces between columns) 	}
{	dleftmargin = 8;		 (left margin)		}
{	dcolumnwidth = 43;		 (width of columns) 	}
{	dpaperwidth = 110;		 (paper width)		}
{	dpagelength = 72;		 (page length)		}
{								}
{								}
{	Written by Ned W. Rhodes				}
{		DTNSRDC						}
{		Code 2950					}
{		Bethesda, Md.  20084				}
{		(202) 227-1592					}
{								}
{								}

var
	width : integer;
	page : array[1 .. 100 , 1 .. 200] of char;
	linebuffer : array[1 .. 200] of char;
	endofdata,firsttime : boolean;
	columnbase,linenumber : integer;
	kount,nextcolumn : integer;
	fin,fout : text;

const

	dfiller = 5;			{ number of spaces between columns }
	dleftmargin = 8;		{ left margin }
	dcolumnwidth = 43;		{ width of columns }
	dpaperwidth = 110;		{ paper width }
	dpagelength = 72;		{ page length }
	formfeed = 14B;
	blank = 40B;

procedure blankpage;
{								}
{								}
{	Blanks the output page					}
{								}
{								}

var
	i,j : integer;

begin

	for i := 1 to 100 do begin
	 for j := 1 to 200 do begin
	  page[i,j] := chr(blank);
	 end;
	end;
end;{blankpage}

procedure pageout;
{								}
{								}
{	Writes the page out					}
{								}
{								}

var
	i,j : integer;

begin

	for i := 1 to dpagelength do begin
	 for j := 1 to dpaperwidth do begin
		write(fout,page[i,j]);
	 end;
	 writeln(fout);				{ write a c/r, l/f }
	end;
	write(fout,chr(formfeed));		{ form feed }

end;{pageout}

procedure writepage;
{								}
{								}
{	Toggle column or output page				}
{								}
{								}

begin
	if eof(fin) then pageout

	else

	if columnbase = dleftmargin then begin
		columnbase := nextcolumn;
		width := columnbase + dcolumnwidth;
		linenumber := 0;
{								}
{								}
{	Find end of abstract to start second column		}
{								}
{								}
		if firsttime then begin
		  repeat
		  linenumber := succ(linenumber);
		  if (page[linenumber,dleftmargin] <> chr(blank)) then
			begin
			firsttime := false;
			linenumber := linenumber - 1;
			end;
		until (not firsttime) or (linenumber > dpagelength);
		end;
		end
	else begin
		pageout;
		columnbase := dleftmargin;
		width := columnbase + dcolumnwidth;
		linenumber := 0;
		end;
end;{writepage}

procedure convertpage;
{								}
{								}
{	Read a line and stuff in the output page		}
{								}
{								}

var
	curchr,i : integer;

begin

repeat
	readln(fin,linebuffer);
	linenumber := succ(linenumber);

	curchr := 1;
	for i := columnbase to width do begin
		if linebuffer[curchr] <> chr(formfeed) then begin
			page[linenumber,i] := linebuffer[curchr];
			curchr := succ(curchr);
			end;
		end;
until (linenumber = dpagelength) or (eof(fin));
end;{convertpage}

begin{main}

	reset(fin,'decus.doc');
	rewrite(fout,'decus.rpt');
	columnbase := dleftmargin;
	linenumber := 0;
	endofdata := false;
	nextcolumn := dcolumnwidth + dleftmargin + dfiller;
	firsttime := true;

	repeat {Main program loop}
		if firsttime then width := dpaperwidth;
		if columnbase = dleftmargin then blankpage;
		convertpage;
		writepage;
	until eof(fin);
end.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            