  program addtodictionary (input, output, dictionary, newwords, revision);

  {**************************************************************}
  {                                                              }
  { Copyright (c) 1981, 83, 84    Bob Schor                      }
  {               86              Rockefeller University         }
  {                               1230 York Ave                  }
  {                               New York, NY   10021           }
  {                                                              }
  { All rights reserved.  May not be copied without this notice. }
  {                                                              }
  {**************************************************************}

  { This software may not be copied without the above copyright notice }

  { Software developed with Oregon Software Pascal 1.2 and 2.0, running
   under RT-11.  Attempts made to conform to ISO standards and avoid
   implementation extensions. }

  { updates dictionary for speller }

  { Version 3.1 -- default input "SPELLT.NON" }
  { Version 3.1 -- ensures sufficient space for update }
  { Version 4.1 -- trailing blanks omitted, sentinels changed }
  { Version 4.1 -- only text files used, absent file extension now "ABS" }
  { Version 4.1 -- Pascal-2 "legalanswer" routine added }
  { Version 6.1 -- full Pascal-2 file name default added }
  { Version 7.5 -- renames original to .OLD }

CONST
  version = 'ADDICT     Version 7.5';
  maxwordlength = 20;
  startofwordlist = 'start-of-sorted-list';
  sentinel = '~~~~~~~~~~~~~~~~~~~~';   { "last" legal ascii word }
TYPE
  answerset = SET OF char;
  wordlengthtype = 1 .. maxwordlength;
  wordtype = PACKED ARRAY [wordlengthtype] OF char;
VAR
  dictionary, newwords, revision : text;
  revisedsize : integer;

  PROCEDURE initialize;

  CONST
    filenamelength = 14;
  TYPE
    nameindextype = 1 .. filenamelength;
    filenametype = PACKED ARRAY [nameindextype] OF char;
  VAR
    dictionarysize, newwordsize : integer;
    dictionaryname, newwordname : filenametype;
    firstword : wordtype;

    PROCEDURE eraseextension (VAR filename : filenametype);

    VAR
      nameindex : nameindextype;

     BEGIN   { eraseextension }
       nameindex := 1;
       WHILE NOT (filename[nameindex] IN [' ', '.']) DO
       nameindex := succ(nameindex);
       FOR nameindex := nameindex TO filenamelength DO
       filename[nameindex] := ' '
     END;

   BEGIN   { initialize }
     writeln;
     writeln (version);
     writeln;
     writeln ('Add to dictionary');
      REPEAT
	REPEAT
	 writeln;
	 write ('Enter dictionary to update [DIXION.DCT] -- ');
	 readln (dictionaryname);
	 reset (dictionary, dictionaryname, 'DIXION.DCT', dictionarysize);
	 IF dictionarysize <= 0
	  THEN writeln ('Dictionary file not found')
	UNTIL dictionarysize > 0;
       readln (dictionary, firstword);
       IF firstword <> startofwordlist
	THEN writeln ('Dictionary file not in proper format.  Try again.')
      UNTIL firstword = startofwordlist;
      REPEAT
	REPEAT
	 writeln;
	 write ('Enter file of new words [SPELLT.ABS] -- ');
	 readln (newwordname);
	 reset (newwords, newwordname, 'SPELLT.ABS', newwordsize);
	 IF newwordsize <= 0
	  THEN writeln ('New word file not found')
	UNTIL newwordsize > 0;
       readln (newwords, firstword);
       IF firstword <> startofwordlist
	THEN
	 BEGIN
	   close (newwords);
	   writeln ('New word file not in proper format.  Try again.')
	 END
      UNTIL firstword = startofwordlist;
     writeln;
     eraseextension (dictionaryname);
     revisedsize := dictionarysize + newwordsize;
     rewrite (revision, dictionaryname, 'DIXION.DCT', revisedsize);
     IF revisedsize <= 0
      THEN writeln ('Not enough room for revised dictionary!!')
   END;

  FUNCTION wordlength (word : wordtype) : wordlengthtype;

  VAR
    trialindex : wordlengthtype;

   BEGIN   { wordlength }
     IF word = '                    '
      THEN wordlength := 1
      ELSE
       BEGIN
	 trialindex := maxwordlength;
	 WHILE word[trialindex] = ' ' DO trialindex := pred(trialindex);
	 wordlength := trialindex
       END
   END;

  PROCEDURE updatedictionary;

  VAR
    correctword, updateword : wordtype;

    PROCEDURE reviseusing (word : wordtype);

     BEGIN   { reviseusing }
       writeln (revision, word:wordlength(word))
     END;

    FUNCTION nextword (VAR whichfile : text) : wordtype;

    VAR
      word : wordtype;

     BEGIN   { nextword }
       IF eof (whichfile)
	THEN word := sentinel
	ELSE readln (whichfile, word);
       nextword := word
     END;

   BEGIN   { updatedictionary }
     readln (dictionary, correctword);
     readln (newwords, updateword);
     writeln (revision, startofwordlist:wordlength(startofwordlist));
     WHILE (correctword <> sentinel) OR (updateword <> sentinel) DO
     IF correctword < updateword
      THEN
       BEGIN
	 reviseusing (correctword);
	 correctword := nextword (dictionary)
       END
      ELSE
      IF correctword > updateword
       THEN
	BEGIN
	  reviseusing (updateword);
	  updateword := nextword (newwords)
	END
       ELSE
	BEGIN
	  reviseusing (correctword);
	  correctword := nextword (dictionary);
	  updateword := nextword (newwords)
	END;
     close (newwords);
     rename (dictionary, '.OLD');
     rename (revision, '.DCT');
     writeln ('Original dictionary has extension .OLD');
     writeln
   END;


 BEGIN   { addtodictionary }
   initialize;
   IF revisedsize > 0
    THEN updatedictionary
 END.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       