	SUBROUTINE FLT REC (N,FLOW,FHIGH,IKIND,X,Y,Z,NPTS)
C
C----------------------------------------------------------------------
C
C	Passes data through an N order recursive digital filter
C
C	N     - Desired order of filter
C	FLOW  - Lower frequency of filter (Range = 0 to 1)
C	FHIGH - Upper frequency of filter (Range = 0 to 1)
C	IKIND - 1 for Butterworth, 2 for 0.1 dB Chebychev
C	X     - Input data array
C	Y     - Output data array
C	Z     - Dummy array (dimensioned the same as x and y)
C	NPTS  - Number of data points in x
C
C----------------------------------------------------------------------
C
	DIMENSION X(1),Y(1),Z(1),A(3),B(2)
	IF (FLOW .NE. 0.) GO TO 10
	F = FHIGH
	ITYPE = 1
	GO TO 30
10	IF (FHIGH .NE. 1.) GO TO 20
	F = FLOW
	ITYPE = 2
	GO TO 30
20	ITYPE = 3
	F = FLOW
	IF (FHIGH .LT. FLOW) ITYPE = 4
30	DO 40 I=1,NPTS
40	Z(I) = X(I)
	CALL RFLTLW (N,F,IKIND,Y,Z,NPTS)
	IF (ITYPE .EQ. 1) RETURN
	IF (ITYPE .GT. 2) GO TO 60
	DO 50 I=1,NPTS
50	Y(I) = X(I) - Y(I)
	RETURN
60	DO 70 I=1,NPTS
70	Z(I) = X(I) - Y(I)
	CALL RFLTLW (N,FHIGH,IKIND,Y,Z,NPTS)
	IF (ITYPE .EQ. 3) RETURN
	DO 90 I=1,NPTS
90	Y(I) = X(I) - Y(I)
	RETURN
	END
	SUBROUTINE R FLT LW (N,F,IKIND,Y,Z,NPTS)
C
C----------------------------------------------------------------------
C
C	Passes data through a second order low pass recursive filter
C	that will eventually be applied N/2 times to produce N
C	order filtering.
C
C	N     - Order of ultimate filter
C	F     - Cutoff frequency desired (Range = 0 to 1)
C	IKIND - 1 or Butterworth, 2 for 0.1 dB Chebychev
C	Y     - Output data array
C	Z     - Input data array (= output on return)
C	NPTS  - Number of data points in Y,Z
C
C----------------------------------------------------------------------
C
	DIMENSION Y(1),Z(1),CONST(10),COEF(8)
	DATA HALFPI /1.57079633/
	DATA CONST /1.,1.316074,1.5033033,1.6404924,1.7504911,
     1		1.,1.2787175,1.4320239,1.5385184,1.6202971/
	DATA COEF /0.92103004,1.3722269,0.29289321,0.6976604,
     1		0.,1.2900624,0.17157287,0.5005791/
C
	NTIMES = (N+1) / 2
	IF (NTIMES .LT. 1) NTIMES = 1
	IF (NTIMES .GT. 5) NTIMES = 5
	IF (IKIND .LT. 1) IKIND = 1
	IF (IKIND .GT. 2) IKIND = 2
	C = CONST(NTIMES + 5*(IKIND-1))
	OMEGA = COEF(IKIND)
	A0 = COEF(IKIND+2)
	B1 = COEF(IKIND+4)
	B0 = COEF(IKIND+6)
	D = ATAN(C*SIN(HALFPI*F)/COS(HALFPI*F))
	IF (D .GT. HALFPI) D = HALFPI
	CA = SIN(OMEGA-D)/SIN(OMEGA+D)
	CA2 = CA*CA
	C1 = 1.+B0*CA2-B1*CA
	C2 = A0*(1.-CA)**2/C1
	C3 = (B1*(1.+CA2)-2.*CA*(1.+B0))/C1
	C4 = (CA2+B0-B1*CA)/C1
	DO 30 J=1,NTIMES
	Y(1) = Z(1)
	Y(2) = Z(2)
	DO 10 I=3,NPTS
10	Y(I) = C2*(Z(I)+2.*Z(I-1)+Z(I-2))-C3*Y(I-1)-C4*Y(I-2)
	DO 20 I=1,NPTS
20	Z(I) = Y(I)
30	CONTINUE
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                     