C	HVPLOT IV
C
C	Terminal identification
c
C
C	3-Mar-88 by 	E Grigolato
C		    	Boyne Smelters Ltd
C		    	Gladstone, Qld. 4680
C		    	Australia
C
C	This section contains the following subroutines.
C	subroutine IDTERM
C	subroutine CLRBUF
C	subroutine OUTPUT
C	subroutine INPUT
C	subroutine IPRINT
C	subroutine SAVE
C	subroutine LOCATE
C	subroutine WHERE
C
	SUBROUTINE IDTERM(TERMID,REPLY)
C	This subroutine determines the type of your consol terminal.
C	The terminals recognised are VT50,VT50H, VT50H with hardcopy
C	unit,VT52, VT52 with hardcopy unit,LA34,LA120,LA12,VT102,VT125
C	VT131,VT132,VT220,VT240,VT241,VT320,VT330,VT340 and VT100 series 
C	terminals.Also terminals in VT52 mode will be changed to ANSI mode
C	and the terminal type determined.
C
	LOGICAL*1 ESC(2),QUERY(80),REPLY(1),TERMID(1)
	ESC(1)=27
	ESC(2)=0
C	SET MONITOR TO ACCESS KEYBOARD IMMEDIATELY
	CALL TTNOW
	CALL RCTRLO
	CALL CLRBUF
C	Try old terminal enquiry i.e. ESC Z valid reply ESC / * 
C	where * is A ,H ,J ,K ,L ,C ,Z
	CALL CONCAT(ESC,'Z',QUERY)
	CALL OUTPUT(QUERY)
	CALL INPUT(REPLY)
	CALL CLRBUF
	IF (LEN(REPLY).LE.0) GOTO 100
	IF (REPLY(2).NE.'/') GOTO 100
C	DETERMINE VT5* TYPE TERMINAL
	CALL SCOPY('UNKNOWN',TERMID)
	IF (REPLY(3).EQ.'A') CALL SCOPY('VT50',TERMID)
	IF (REPLY(3).EQ.'H') CALL SCOPY('VT50H',TERMID)
	IF (REPLY(3).EQ.'J') CALL SCOPY('VT50H with copier',TERMID)
	IF (REPLY(3).EQ.'K') CALL SCOPY('VT52',TERMID)
	IF (REPLY(3).EQ.'L') CALL SCOPY('VT52 with copier',TERMID)
	IF (REPLY(3).EQ.'C') CALL SCOPY('VT55',TERMID)
	IF (REPLY(3).EQ.'Z') CALL SCOPY('VT100 in VT52 mode',TERMID)
	IF (REPLY(3).EQ.'Z') GOTO 50
D	I=ISCOMP(TERMID,'UNKNOWN')
D	IF (I.NE.0) GOTO 1000
D		CALL IPRINT(TERMID,REPLY)
	GOTO 1000
C	VT100,VT200 OR VT300 SERIES TERMINALS IN VT52 MODE
50	CONTINUE
D	CALL PRINT(TERMID)
C	CHANGE TERMINAL TO ANSI MODE
	CALL CONCAT(ESC,'<',QUERY)
	CALL OUTPUT(QUERY)
C	Send ESC A to shift cursor up in case terminal is a VT52 but fails
C	to reply due to line noise.In that case the ANSI query will freeze
C	the terminal.On program exit a SET UNSCROLL command ( ESC \ ) will
C	be transmitted to the consol.
C
C	determine terminal type
100	CALL CONCAT(ESC,'A',QUERY)
C	GENERATE ANSI QUERY
	CALL CONCAT(QUERY,ESC,QUERY)
	CALL CONCAT(QUERY,'[c',QUERY)
	CALL OUTPUT(QUERY)
	CALL INPUT(REPLY)
	CALL SCOPY('UNKNOWN',TERMID)
	IF (LEN(REPLY).LE.0) GOTO 1000
C	DETERMINE WHAT TYPE OF ANSI TERMINAL
C	HARDCOPY TERMINALS
	I=INDEX(REPLY,'[?15')
	IF (I.EQ.2) CALL SCOPY('LA12',TERMID)
	I=INDEX(REPLY,'[?10')
	IF (I.EQ.2) CALL SCOPY('LA100',TERMID)
	I=INDEX(REPLY,'[?2')
	IF (I.EQ.2) CALL SCOPY('LA120',TERMID)
	I=INDEX(REPLY,'[?3')
	IF (I.EQ.2) CALL SCOPY('LA34',TERMID)
	I=INDEX(REPLY,'[?13')
	IF (I.EQ.2) CALL SCOPY('LQP02',TERMID)
C	VDU TERMINALS
	I=INDEX(REPLY,'[?1')
	IF (I.EQ.2) CALL SCOPY('VT100',TERMID)
	I=INDEX(REPLY,'[?1;0')
	IF (I.EQ.2) CALL SCOPY('VT101',TERMID)
	I=INDEX(REPLY,'[?6')
	IF (I.EQ.2) CALL SCOPY('VT102',TERMID)
	I=INDEX(REPLY,'[?12')
	IF (I.EQ.2) CALL SCOPY('VT125',TERMID)
	I=INDEX(REPLY,'[?7')
	IF (I.EQ.2) CALL SCOPY('VT131',TERMID)
	I=INDEX(REPLY,'[?4')
	IF (I.EQ.2) CALL SCOPY('VT132',TERMID)
	I=INDEX(REPLY,'[?5')
	IF (I.EQ.2) CALL SCOPY('VK100',TERMID)
	I=INDEX(REPLY,'[?61')
	IF (I.EQ.2) CALL SCOPY('VT100 SERIES',TERMID)
	I=INDEX(REPLY,'[?62;1;2;6')
	IF (I.EQ.2) CALL SCOPY('VT220',TERMID)
	I=INDEX(REPLY,'[?62;1;2;3;4;6')
	IF (I.EQ.2) CALL SCOPY('VT200',TERMID)
	I=INDEX(REPLY,'[?63;1;2;6')
	IF (I.EQ.2) CALL SCOPY('VT320',TERMID)
	I=INDEX(REPLY,'[?63;1;2;3;4;6')
	IF (I.EQ.2) CALL SCOPY('VT300',TERMID)
	I=ISCOMP(TERMID,'VT200')
	IF (I.EQ.0) GOTO 200
	I=ISCOMP(TERMID,'VT300')
	IF (I.EQ.0) GOTO 200
D	I=ISCOMP(TERMID,'UNKNOWN')
D	IF (I.NE.0) GOTO 1000
D	CALL IPRINT(TERMID,REPLY)
	GOTO 1000
200	CALL CONCAT(ESC,'[>c',QUERY)
	CALL OUTPUT(QUERY)
	CALL INPUT(REPLY)
	IF (LEN(REPLY).LE.0) GOTO 1000
	CALL CLRBUF
C	VT240 OR VT241 ?
	I=ISCOMP(TERMID,'VT200')
	IF (I.NE.0) GOTO 300
C	can not tell a VT240 & a VT241 apart
		I=INDEX(REPLY,'[>2')
		IF (I.EQ.2)CALL SCOPY('VT240',TERMID)
C	or is it a VT330 or VT340 impersonating a VT240
C	VT330 OR VT340 ?
300		I=INDEX(REPLY,'[>18')
		IF (I.EQ.2)CALL SCOPY('VT330',TERMID)
		I=INDEX(REPLY,'[>19')
		IF (I.EQ.2)CALL SCOPY('VT340',TERMID)
D		I=ISCOMP(TERMID,'VT300')
D		IF (I.EQ.0) CALL IPRINT(TERMID,REPLY)
D		I=ISCOMP(TERMID,'VT200')
D		IF (I.EQ.0) CALL IPRINT(TERMID,REPLY)
C	
1000	CALL CLRBUF
C	TRANSMIT SET UNSCROLL FOR VT52 JUST IN CASE
	CALL CONCAT(ESC,'\',QUERY)
	CALL OUTPUT(QUERY)
	CALL CLRBUF
	CALL TTNORM
	call strpad(termid,8)
D	CALL IPOKE("44,"167777.AND.IPEEK("44)) ! RESET TERMINAL TO NORMAL MODE
D	CALL IPRINT(TERMID,REPLY)
	RETURN
	END
	SUBROUTINE CLRBUF
C	Clears input buffer of unwanted characters.
5	K=30
10	ICHAR=ITTINR()
	IF (ICHAR.GT.0) GOTO 5
	K=K-1
	IF (K.GT.0) GOTO 10
	RETURN
	END
	SUBROUTINE INPUT(STRING)
C	This subroutine reads characters from the system consol directly.
C	The counter is used as a timer for systems without clocks.
	LOGICAL*1 STRING(1)
	K=1000
	I=1
10	ICHAR=ITTINR()
	K=K-1
	IF (K.LT.0) GOTO 20
	IF (ICHAR.LT.0) GOTO 10
	STRING(I)=ICHAR
	I=I+1
	K=1000
	GOTO 10
20	STRING(I)=0
	RETURN
	END
	SUBROUTINE OUTPUT(STRING)
C	This subroutine sends characters to the system consol directly.
	LOGICAL*1 STRING(1)
	I=LEN(STRING)
	IF (I.EQ.0) GOTO 100
	DO 10 J=1,I
5		IF (ITTOUR(STRING(J)).NE.0) GOTO 5
10	CONTINUE
100	RETURN
	END
	SUBROUTINE IPRINT(TERMID,STRING)
C	If terminal gives an unknown response the terminal reply is 
C	printed on the consol.
C
C	HP and TT contain the device numbers for the terminal and the plotter
	integer hp,tt
	common	/HPTTNO/hp,tt
c
	LOGICAL*1 STRING(1),CHAR,TERMID(1)
	write(tt,5)(TERMID(I),I=1,LEN(TERMID))
5	FORMAT(X,'The consol is ',40A1)
	write(tt,6)
6	FORMAT(X,'Your terminal reply was :')
	DO 10 I=1,LEN(STRING)
		CHAR=STRING(I)
		IF (CHAR.LT.32)CHAR=32
10	write(tt,20)I,STRING(I),CHAR
20	FORMAT(X,'CHAR NO ',I5,' = ',I5,' ',A1)
	write(tt,30)
30	FORMAT(X)
	RETURN
	END
c	obtain the current cursor position in user units

	subroutine save(xw,yw) 

	common	/zzhv/hv,plonsw,flh,flv,flsh,flsv
	byte	hv,plonsw,flh,flv,flsh,flsv

	common	/zzhpf/xmin,xmax,ymin,ymax
	common 	/zzvf/xminv,xmaxv,yminv,ymaxv
	common	/zzvsc/xmul,ymul

	common	/zzhpb/etx,si,so,esc,EPp(3),Ebsl(2),dum
	byte	etx,si,so,esc,EPp,Ebsl,dum

C	CONTROLLED ABORT FLAG
	INTEGER Q
	COMMON /zflag/Q
C
C	HP and TT contain the device numbers for the terminal and the plotter
	integer hp,tt
	common	/HPTTNO/hp,tt

	LOGICAL*1 INPUT(80),error

	if(hv)goto 500

c	Not required by plotter
	goto 999

500	if(.not.(flv.and.flsv))stop 'Call INIT and SCALE first'
	j=0
510	write(tt,1000)esc
1000	format('+',a1,'PpR(P);')
	read(tt,1020)(INPUT(I),I=1,80)
1020	FORMAT(80A1)
	write(tt,1025)esc
1025	FORMAT('+',A1,'\')
	input(80)=0
	call trim(input)
	j=j+1
	call where(input,xw,yw,error)
	if ((error).and.(j.lt.10)) goto 510
	if (error)stop'HVPLOT-F-error can not obtain cursor location'
999	return
	end

c	allows mouse or cursor input to indicate screen location
c	returns result in user units and button pressed
c
	subroutine locate(xw,yw,ipress)
c
	common	/zzhv/hv,plonsw,flh,flv,flsh,flsv
	byte	hv,plonsw,flh,flv,flsh,flsv

	common	/zzhpf/xmin,xmax,ymin,ymax
	common 	/zzvf/xminv,xmaxv,yminv,ymaxv
	common	/zzvsc/xmul,ymul

	common	/zzhpb/etx,si,so,esc,EPp(3),Ebsl(2),dum
	byte	etx,si,so,esc,EPp,Ebsl,dum

C	CONTROLLED ABORT FLAG
	INTEGER Q
	COMMON /zflag/Q
C
C	HP and TT contain the device numbers for the terminal and the plotter
	integer hp,tt
	common	/HPTTNO/hp,tt

	LOGICAL*1 INPUT(80),output(20),ERROR

	if(hv)goto 500

c	Not required by plotter
	goto 999
500	if(.not.(flv.and.flsv))stop 'Call INIT and SCALE first'
510	write(tt,1000)esc
1000	format('+',a1,'P1p;R(I0);R(P(I));')
600	read(tt,1020)(INPUT(I),I=1,80)
	input(80)=0
	call trim(input)
	if (len(input).eq.0) goto 600
1020	FORMAT(80A1)
	write(tt,1025)esc
1025	FORMAT('+',A1,'\')
	input(80)=0
	call trim(INPUT)
	call where(input,xw,yw,error)
	if (error.eq..FALSE.) goto 625
c	error in location
		call status
		write(tt,1027)
1027	format('+','Can not determine cursor location',
	1 ',please re-enter',$)
	goto 510
625	m=index(input,'~')
	if (m.le.1)goto 700
	i=index(input,'[',1)
	call substr(input,output,i+1,m-i-1)
	l=len(output)
	decode(l,1030,output,err=650)ipress
1030	format(i6)
	ipress=ipress+1000
	goto 800
650		call status
		write(tt,675)
675	format('+Can not work out whick key you pressed',
	1 ' - please re-enter',$)
	goto 510
	return
700	ipress=input(1)
	if ((input(1).eq.'[').and.(input(2).ne.'['))ipress=13
800	CONTINUE
999	return
	end
C
C	determine the point the cursor was at in user units.
C
	Subroutine Where(input,xw,yw,error)		!Where

C	HP and TT contain the device numbers for the terminal and the plotter
	integer hp,tt
	common	/HPTTNO/hp,tt


	common	/zzhpf/xmin,xmax,ymin,ymax
	common	/zzvf/xminv,xmaxv,yminv,ymaxv
	common	/zzvsc/xmul,ymul


	common	/zzhv/hv,plonsw,flh,flv,flsh,flsv
	byte	hv,plonsw,flh,flv,flsh,flsv

	logical*1 output(20),input(1),error
	if(hv)goto 500
c	not required for plotter
	goto 999

500	error=.false.
	m=1
	m=index(input,'~')
	if (m.eq.0)m=1
	if ((input(1).eq.'[').and.(input(2).eq.'['))m=2
	i=index(input,'[',m)
	j=index(input,',',i)
	k=index(input,']',j)
	call substr(input,output,i+1,j-i-1)
	l=len(output)
	decode(l,1000,output,err=888)x
	call substr(input,output,j+1,k-j-1)
	l=len(output)
	decode(l,1000,output,err=888)y
1000	format(f13.0)
	xw=x/xmul+xminv
	yw=(449-y)/ymul+yminv
	goto 999
C	error in output from terminal
888	error=.true.
999	return
	end
                                                                                                                                                                                                                                                                                                                                                                                                                          