	program plane
C
C  Airplane Landing Game
C
C    Original version by Bill Greene, Digital
C
C    Revised by William K. Walker, RDB/Alpha Systems, 24 Nov 87
C      - added VT100 support
C      - fixed bug in terminal ID logic
C      - other minor corrections
C
C    Revisions are in lower case; original code is all upper case.
C
	INTEGER K,G,F1,R,S,L,M,TERM
	COMMON TERM
	LOGICAL*1	W1,W2
	REAL	F,H,A,V,V1,V2,B,B0,V0,A0,H0,V9,D,D1,H8,H9,D2,T,C,I
	L=0
	M=0
	TYPE    86
86	FORMAT (' AIRPLANE LANDING GAME -  BY BILL GREENE, DIGITAL
	1 EQUIPMENT CORP.'/'   Revised 24 Nov 87 by Wm. K. Walker,
	2 RDB/Alpha Systems')
1	TYPE	970
	ACCEPT 2,TERM
2	FORMAT(I4)
	if (term.gt.2) go to 1
8	CALL	HOME
	CALL	EOS
	CALL	EOS
	TYPE	800
	TYPE	805
	ACCEPT	810,Z
	TYPE	815
	CALL NULL
	CALL	IQSET(10)
	CALL	IPOKE("44,"50100.OR.IPEEK("44))
	IF	(Z.EQ.'NO')GO TO 5
	IF	(Z.EQ.'N') GO TO 5
	if	(z.eq.'no')go to 5
	if	(z.eq.'n') go to 5
	CALL	HOME
	CALL	EOS
	CALL	EOS
	CALL	PAGE1
3	CALL	ISLEEP(0,0,1,0)
	K=ITTINR()
	IF	(K.LT.0) GO TO 3
	IF	(K.NE.32) GO TO 3
	TYPE	815
	CALL NULL
	CALL	HOME
	CALL	EOS
	CALL	EOS
	CALL	PAGE2
4	CALL	ISLEEP(0,0,1,0)
	K=ITTINR()
	IF	(K.LT.0) GO TO 4
	IF	(K.NE.32) GO TO 4
5	TYPE	815
	CALL NULL
	CALL	HOME
	CALL	EOS
	CALL	EOS
	CALL	PANEL
	D=32000
	D1=30000
	I=0
	T=0
	C=281
	C1=281
	S=0
	G=0
	A0=7
	B0=0
	V0=0
	H0=2300
	V9=0
	F=1000
	F1=1
	H=2500
	A=8
	B=25
	V=125
	V1=0
	V2=0
10	A1=-32+V*SIN(A*6.28318531/180)
	H=H+V1+(.5*A1)
	V1=V1+A1
	V1=(V1+V2)/2
	V2=V1
	V=V-(.1*V)+(.5*B)-(.4*V1)-(10*G)
	IF(V.GT.55)GO TO 13
	S=1
13	IF(V.LT.80)GO TO 15
	S=0
15	IF(S.EQ.0)GO TO 17
	A=A-2
	H=H-50
17	F=F-ABS(B/4)
	IF(V.GT.64)GO TO 19
	IF(G.EQ.1)GO TO 19
	W1=58
	W2=10
	CALL	CURFOR(W1,W2)
	TYPE	910
	CALL	ISLEEP(0,0,0,30)
	CALL	CURFOR(W1,W2)
	TYPE	911
	CALL	ISLEEP(0,0,0,30)
	GO TO 20
19	CALL	ISLEEP(0,0,1,0)
20	W1=58
	W2=6
	CALL	CURFOR(W1,W2)
	Z=RAN(L,M)
	K=ITTINR()
	IF (K.LT.0) GO TO 32
	IF (K.EQ.65) GO TO 22
	IF (K.NE.26) GO TO 23
22	A=A+1
	GO TO 20
23	IF (K.EQ.66) GO TO 24
	IF (K.NE.11) GO TO 25
24	A=A-1
	GO TO 20
25	IF (K.EQ.68) GO TO 26
	IF (K.NE.8) GO TO 27
26	B=B-1
	GO TO 20
27	IF (K.EQ.67) GO TO 28
	IF (K.NE.24) GO TO 29
28	B=B+1
	GO TO 20
29	IF (K.NE.49) GO TO 30
	CALL	LEFT(T)
	GO TO 20
30	IF (K.NE.50) GO TO 31
	CALL	LEVEL(T)
	GO TO 20
31	IF (K.NE.51) GO TO 20
	CALL	RIGHT(T)
	GO TO 20
32	IF(H.GT.0)GO TO 37
	IF(G.EQ.1)GO TO 33
	IF(V1.LT.-10)GO TO 300
	IF(D.GT.1500)GO TO 320
	IF(D.LT.-2500)GO TO 320
	IF(R.EQ.1)GO TO 37
	IF(V.GT.100)GO TO 200
33	H=0
	V1=0
	G=1
	IF(A.GT.8.0)GO TO 35
	A=8.0
35	A=A-1
	IF(V.LT.15)GO TO 315
	IF(B.EQ.0)GO TO 38
	B=B-1
	GO TO 38
37	G=0
	IF(R.EQ.0)GO TO 38
	R=0
	A=A-3
38	W1=3
	W2=12
	CALL	CURFOR(W1,W2)
	TYPE 900,H
	W1=15
	W2=12
	CALL	CURFOR(W1,W2)
	TYPE	900,V1
	IF(F.GE.0)GO TO 39
	F=0
	F1=0
39	B=B*F1
	W1=55
	W2=6
	CALL	CURFOR(W1,W2)
	TYPE	900,F
	IF(B.LE.36.0)GO TO 40
	B=36
40	IF(B.GE.0)GO TO 42
	B=0
42	CALL	POWER(B,B0)
	B0=B
	CALL	SPEED(V,V0)
	V0=V
	CALL	ATT(A,A0)
	A0=A
	CALL	ALT(H,H0)
	IF(ABS(H-H0).LT.100.0)GO TO 45
	H0=H
45	CALL	CLIMB(V1,V9)
	IF(ABS(V9-V1).LT.1.6)GO TO 47
	V9=V1
47	IF (T.EQ.0.) GO TO 50
	C=C+T
	IF (C.LT.361.) GO TO 48
	C=1
48	IF (C.GT.0.) GO TO 49
	C=360
49	W1=31
	W2=2
	CALL	CURFOR(W1,W2)
	TYPE	900,C
50	IF(C.NE.C1)GO TO 52
	D=D-(1.5*V)
52	IF(G.EQ.1)GO TO 520
	IF(D.LT.1500)GO TO 500
	IF(D.LT.D1)GO TO 400
	GO TO 10

200	A=A+3
	R=1
	H=20
	GO TO 10


300	CALL	HOME
	CALL	EOS
	CALL	EOS
	W1=30
	W2=9
	CALL	CURFOR(W1,W2)
	CALL	ISLEEP(0,0,1,0)
	TYPE	950
310	CALL	ISLEEP(0,0,3,0)
315	CALL	HOME
	CALL	EOS
	CALL	EOS
	CALL	ISLEEP(0,0,1,0)
	GO TO 990

320	CALL	HOME
	CALL	EOS
	CALL	EOS
	CALL	ISLEEP(0,0,0,30)
	W1=10
	W2=9
	CALL	CURFOR(W1,W2)
	TYPE	960
	GO TO 310

400	D1=D1-500
	W1=46
	W2=1
	CALL CURFOR(W1,W2)
	IF(D1.EQ.29500)GO TO 530
	IF(D1.EQ.29000)GO TO 535
	IF(D1.EQ.28000)GO TO 550
	IF(D1.EQ.21000)GO TO 540
	IF(D1.EQ.20000)GO TO 555
	IF(D1.EQ.18000)GO TO 545
	IF(D1.GT.17500)GO TO 10
	H9=.0875*D
	IF(H.LT.H9-50)GO TO 420
	IF(H.GT.H9+50)GO TO 440
	IF(I.GT.2)GO TO 560
	TYPE 700
	IF(T.NE.0)GO TO 10
	I=I+1
	GO TO 10

420	H8=H9-H
	TYPE 720,H8
	GO TO 10

440	H8=H-H9
	TYPE 740,H8
	GO TO 10

500	IF(D.GE.D1)GO TO 10
	D1=D1-500
	IF(D.GE.-2500)GO TO 510
	IF (H.GT.100)GO TO 515
	GO TO 300
510	D2=ABS(-3000-D1)
	W1=46
	W2=1
	CALL	CURFOR(W1,W2)
	TYPE 790,D2
	GO TO 10

515	W1=46
	W2=1
	CALL	CURFOR(W1,W2)
	TYPE 760
	GO TO 10

520	W1=46
	W2=1
	CALL	CURFOR(W1,W2)
	TYPE 780
	GO TO 10

530	TYPE 710
	GO TO 10
535	TYPE 711
	GO TO 10
540	TYPE 712
	GO TO 10
545	TYPE 713
	GO TO 10
550	C3=120
	CALL	COURSE(C3,C,C1,L,M)
	GO TO 10
555	C3=30
	CALL	COURSE(C3,C,C1,L,M)
	GO TO 10
560	I=0
	C3=10
	CALL	COURSE(C3,C,C1,L,M)
	GO TO 10

700	FORMAT('+YOU ARE ON GLIDEPATH     '$)
710	FORMAT('+ YOU ARE IN RADAR CONTACT'$)
711	FORMAT('+ DESCEND TO 1500 FEET    '$)
712	FORMAT('+ SLOW AIRCRAFT TO 90 MPH '$)
713	FORMAT('+ BEGIN 10 FPS DESCENT    '$)
720	FORMAT('+YOU ARE '$,F4.0,'FEET LOW  '$)
740	FORMAT('+YOU ARE '$,F4.0,'FEET HIGH '$)
760	FORMAT('+MISSED APPROACH-GO AROUND'$)
780	FORMAT('+  NICE LANDING           '$)
790	FORMAT('+',F5.0,' FEET OF RUNWAY LEFT'$)

800	FORMAT (' AIRCRAFT INSTRUMENT FLIGHT SIMULATION GAME')
805	FORMAT (' DO YOU WANT INSTRUCTIONS ? '$)
810	FORMAT (A3)
815	FORMAT('  ')
820	FORMAT(A1)


900	FORMAT ('+',F5.0$)
910	FORMAT('+*'$)
911	FORMAT('+ '$)
950	FORMAT ('+NOW YOU DID IT'$)
960	FORMAT('+HOW DID WE GET IN THIS CORNFIELD?'$)
970	format(' ENTER 0 FOR VT05, 1 FOR VT52, 2 FOR VT100 :'$)
980	FORMAT(' DO YOU WANT TO FLY AGAIN ? '$)
990	CALL HOME
	CALL EOS
	CALL EOS
	TYPE 980
995	K=ITTINR()
	IF(K.LT.0)GO TO 995
996	IF(ITTOUR(K).NE.0)GO TO 996
	IF (K.EQ."116)GO TO 998
	IF (K.EQ."156)GO TO 998
	GO TO 5




998	END


	SUBROUTINE	PANEL
c	COMMON TERM
	TYPE	900
	CALL NULL
	TYPE	901
	CALL NULL
	TYPE	902
	CALL NULL
	TYPE	903
	CALL NULL
	TYPE	904
	CALL NULL
	TYPE	905
	CALL NULL
	TYPE	906
	CALL NULL
	TYPE	907
	CALL NULL
	TYPE	908
	CALL NULL
	TYPE	909
	CALL NULL
	TYPE	910
	CALL NULL
	TYPE	911
	CALL NULL
	TYPE	912
	CALL NULL
	TYPE	913
	CALL NULL
	TYPE	914
	CALL NULL
	TYPE	915
	CALL NULL
	TYPE	916
	CALL NULL
	TYPE	917
	CALL NULL
	TYPE	918
	CALL NULL
	TYPE	919
	CALL NULL

900	FORMAT ('+  ALTITUDE     CLIMB      + + + + + + + +    --
	2----COMMUNICATIONS------ ')
901	FORMAT ('+! 5000    !  ! 25    !    +   HEADING   +   +  
	2                        +')
902	FORMAT ('+! 4500    !  ! 20    !    +     281     +   +  
	2                        +')
903	FORMAT ('+! 4000    !  ! 15    !    + + + + + + + +    --
	2------------------------')
904	FORMAT ('+! 3500    !  ! 10    !         +++++           
	2    * * * * * * *')
905	FORMAT ('+! 3000    !  !  5    !       +       +         
	2    *   FUEL    *')
906	FORMAT ('+! 2500    !  !  0    !     +           +       
	2    *           *')
907	FORMAT ('+! 2000    !  ! -5    !    +             +      
	2    * * * * * * *')
908	FORMAT ('+! 1500    !  !-10    !   +---- _____ ----+')
909	FORMAT ('+! 1000    !  !-15    !    +             +')
910	FORMAT ('+! 0500    !  !-20    !     +           +
	2 STALL WARNING   [ ]')
911	FORMAT ('+! 0000    !  !-25    !       +       +         
	2   ')
912	FORMAT ('+ [  2500 ]    [   6 ]          +++++           
	2   ')
913	FORMAT ('+---------------------------AIRSPEED------------
	2------------------------')
914	FORMAT ('+40     60     80    100    120    140    160   
	2 180    200')
915	FORMAT ('+ ')
916	FORMAT ('+----------------------------POWER--------------
	2------------------------')
917	FORMAT ('+0     10     20     30     40     50     60    
	2 70     80     90    100')
918	FORMAT ('+ ')
919	FORMAT ('+-----------------------------------------------
	2------------------------'$)
	RETURN
	END

	SUBROUTINE SPEED (V,V0)
	INTEGER Y,P0,P
	P=V/4
	P0=V0/4
	IF(P0.GE.0)GO TO 10
	P0=0
10	Y=15
	CALL	BAR(P,P0,Y)
	RETURN
	END


	SUBROUTINE POWER (B,B0)
	INTEGER Y,P0,P
	P=B*2
	P0=B0*2
	Y=18
	CALL	BAR (P,P0,Y)
	RETURN
	END


	SUBROUTINE BAR(P,P0,Y)
	INTEGER	I,P1,P0,P
	IF(P.LE.71) GO TO 750
	P=71
750	IF(P.GE.0) GO TO 770
	P=0
770	IF(P.EQ.P0) GO TO 820
	IF(P.GT.P0) GO TO 800
	CALL	CURFOR(P,Y)
	CALL	EOL
	GO TO 820
800	P1=P-P0
	IF(P0.LE.71) GO TO 803
	P=71
803	IF(P0.GE.0) GO TO 806
	P0=0
806	CALL	CURFOR(P0,Y)
809	DO 810 I=1,P1
	TYPE 830
810	CONTINUE
820	RETURN
830	FORMAT('+>'$)
	END


	SUBROUTINE CLIMB(V1,V9)
	INTEGER Z
	IF(ABS(V1-V9).LT.1.6)GO TO 100
	Z=(V9+25)/1.5
	IF(Z.GE.1)GO TO 30
	Z=1
30	CALL	VERTCL(18,1,3,33,Z)
	Z=(V1+25)/1.5
	IF(Z.GE.1)GO TO 50
	Z=1
50	CALL	VERT(18,1,3,33,Z)
100	RETURN
	END

	SUBROUTINE ALT(H,H0)
	INTEGER Z
	IF(ABS(H-H0).LT.100.0)GO TO 100
	Z=H0/150
	IF(Z.GE.1)GO TO 30
	Z=1
30	CALL	VERTCL(7,1,3,33,Z)
	Z=H/150
	IF(Z.GE.1)GO TO 50
	Z=1
50	CALL	VERT(7,1,3,33,Z)
100	RETURN
	END

	SUBROUTINE ATT(A,A0)
	INTEGER Z
	IF (A.EQ.A0)GO TO 100
	Z=A0+3
	IF (Z.GE.1) GO TO 30
	Z=1
30	CALL	VERTCL(31,5,5,21,Z)
	Z=A+3
	IF (Z.GE.1) GO TO 50
	Z=1
50	CALL	VERT(31,5,5,21,Z)
100	RETURN
	END

	SUBROUTINE VERT(X,Y,N,M,Z)
	INTEGER X,Y,N,M,Z,L,Y1,X1,I
	IF (Z.LE.M) GO TO 10
	Z=M
10	Z=M-Z
	L=MOD(Z,3)+1
	Y1=Y+Z/3
	X1=X
	CALL	CURFOR(X1,Y1)
	DO 300 I=1,N
	GO TO(120,110,100)L
100	TYPE 200
	GO TO 300
110	TYPE 210
	GO TO 300
120	TYPE 220
300	CONTINUE
	RETURN
200	FORMAT ('+_'$)
210	FORMAT ('+-'$)
220	FORMAT ('+^'$)
	END


	SUBROUTINE VERTCL(X,Y,N,M,Z)
	INTEGER X,Y,N,M,Z,X1,Y1,I
	IF (Z.LE.M) GO TO 10
	Z=M
10	Z=M-Z
	Y1=Y+Z/3
	X1=X
	CALL	CURFOR(X1,Y1)
	DO 100 I=1,N
	TYPE 200
100	CONTINUE
	RETURN
200	FORMAT ('+ '$)
	END

	SUBROUTINE LEFT(T)
	LOGICAL*1 W1,W2
	T=-1.0
	W1=36
	W2=7
	CALL	CURFOR(W1,W2)
	TYPE	820
	W1=27
	W2=9
	CALL	CURFOR(W1,W2)
	TYPE	820
	W1=27
	W2=7
	CALL	CURFOR(W1,W2)
	TYPE	800
	W1=26
	W2=8
	CALL	CURFOR(W1,W2)
	TYPE	810
	W1=37
	W2=8
	CALL	CURFOR(W1,W2)
	TYPE	810
	W1=36
	W2=9
	CALL	CURFOR(W1,W2)
	TYPE	800
	RETURN
800	FORMAT	('+^-_'$)
810	FORMAT	('+    '$)
820	FORMAT	('+   '$)
	END

	SUBROUTINE	RIGHT(T)
	LOGICAL*1 W1,W2
	T=1.0
	W1=27
	W2=9
	CALL	CURFOR(W1,W2)
	TYPE	800
	W1=36
	W2=9
	CALL	CURFOR(W1,W2)
	TYPE	820
	W1=27
	W2=7
	CALL	CURFOR(W1,W2)
	TYPE	820
	W1=37
	W2=8
	CALL	CURFOR(W1,W2)
	TYPE	810
	W1=26
	W2=8
	CALL	CURFOR(W1,W2)
	TYPE	810
	W1=36
	W2=7
	CALL	CURFOR(W1,W2)
	TYPE	800
	RETURN
800	FORMAT	('+_-^'$)
810	FORMAT	('+    '$)
820	FORMAT	('+   '$)
	END

	SUBROUTINE	LEVEL(T)
	LOGICAL*1 W1,W2
	T=0
	W1=27
	W2=7
	CALL	CURFOR(W1,W2)
	TYPE	800
	W1=36
	W2=9
	CALL	CURFOR(W1,W2)
	TYPE	800
	W1=27
	W2=9
	CALL	CURFOR(W1,W2)
	TYPE	800
	W1=36
	W2=7
	CALL	CURFOR(W1,W2)
	TYPE	800
	W1=26
	W2=8
	CALL	CURFOR(W1,W2)
	TYPE	810
	W1=37
	W2=8
	CALL	CURFOR(W1,W2)
	TYPE	810
	RETURN
800	FORMAT('+   '$)
810	FORMAT('+----'$)
	END
	SUBROUTINE	COURSE(C3,C,C1,L,M)
	C1=C3*RAN(L,M)
	C1=INT(C1)+C-(C3/2)
	C2=C-C1
	IF (C2.EQ.0)GO TO 20
	IF (C2.GT.0)GO TO 10
	TYPE	732,C1
	GO TO 20
10	TYPE	730,C1
20	RETURN
730	FORMAT('+TURN LEFT HEADING '$,F4.0,'  '$)
732	FORMAT('+TURN RIGHT HEADING '$,F4.0,' '$)
	END

	SUBROUTINE PAGE1
c	COMMON TERM
	TYPE	1
	CALL NULL
	TYPE	2
	CALL NULL
	TYPE	3
	CALL NULL
	TYPE	4
	CALL NULL
	TYPE	5
	CALL NULL
	TYPE	6
	CALL NULL
	TYPE	7
	CALL NULL
	TYPE	8
	CALL NULL
	TYPE	9
	CALL NULL
	TYPE	10
	CALL NULL
	TYPE	11
	CALL NULL
	TYPE	12
	CALL NULL
	TYPE	13
	CALL NULL
	TYPE	14
	CALL NULL
	TYPE	15
	CALL NULL
	TYPE	4
	CALL NULL
	TYPE	4
	CALL NULL
	TYPE	20
	CALL NULL
	RETURN

1	FORMAT('+THIS PROGRAM PROVIDES A PSEUDO-GRAPHIC VIDEO')
2	FORMAT('+PRESENTATION OF A PILOT''S INSTRUMENT PANEL,')
3	FORMAT('+WITH REAL-TIME UPDATES AT 1 SECOND INTERVALS.')
4	FORMAT('+ ')
5	FORMAT('+THE FOLLOWING KEYS ARE YOUR CONTROLS-')
6	FORMAT('+ ')
7	FORMAT('+UP ARROW -	 NOSE UP')
8	FORMAT('+DOWN ARROW -	 NOSE DOWN')
9	FORMAT('+RIGHT ARROW -	 INCREASE POWER')
10	FORMAT('+LEFT ARROW -	 DECREASE POWER')
11	FORMAT('+1 - TURN LEFT')
12	FORMAT('+2 - FLY STRAIGHT')
13	FORMAT('+3 - TURN RIGHT')
14	FORMAT('+ ')
15	FORMAT('+THEY MAY BE DEPRESSED REPEATEDLY FOR GROSS CHANGES')
20	FORMAT('+         DEPRESS SPACE BAR FOR NEXT PAGE'$)
	END

	SUBROUTINE PAGE2
c	COMMON TERM
	TYPE	1
	CALL NULL
	TYPE	2
	CALL NULL
	TYPE	3
	CALL NULL
	TYPE	4
	CALL NULL
	TYPE	5
	CALL NULL
	TYPE	6
	CALL NULL
	TYPE	7
	CALL NULL
	TYPE	8
	CALL NULL
	TYPE	9
	CALL NULL
	TYPE	10
	CALL NULL
	TYPE	11
	CALL NULL
	TYPE	12
	CALL NULL
	TYPE	13
	CALL NULL
	TYPE	14
	CALL NULL
	TYPE	15
	CALL NULL
	TYPE	16
	CALL NULL
	TYPE	17
	CALL NULL
	TYPE	18
	CALL NULL
	RETURN

1	FORMAT	('+WHEN THE GAME STARTS ')
2	FORMAT	('+YOU WILL BE FLYING LEVEL AT 2500 FEET.')
3	FORMAT	('+INSTRUCTIONS FROM THE GROUND RADAR CONTROLLER')
4	FORMAT	('+WILL APPEAR IN THE UPPER R.H. CORNER OF THE SCREEN.')
5	FORMAT	('+HE WILL ATTEMPT TO TALK YOU DOWN SAFELY.')
6	FORMAT	('+ ')
7	FORMAT	('+PLEASE NOTE THE FOLLOWING:')
8	FORMAT	('+ ')
9	FORMAT	('+THE PLANE WILL STALL BELOW 75 MPH')
10	FORMAT	('+TOUCHDOWN ABOVE 100 MPH RESULTS IN A BOUNCE')
11	FORMAT	('+DESCENT RATE MUST BE BELOW -10 FPS AT TOUCHDOWN')
12	FORMAT	('+A 100 FOOT HILL IS AT THE FAR END OF THE RUNWAY')
13	FORMAT	('+THE FUEL SUPPLY IS MARGINAL')
14	FORMAT	('+NOT FLYING THE CORRECT HEADING WASTES GAS')
15	FORMAT	('+A FORCED LANDING IS POSSIBLE IF TOUCHDOWN IS GENTLE')
16	FORMAT	('+ ')
17	FORMAT	('+ ')
18	FORMAT	('+        DEPRESS SPACE BAR TO BEGIN')
	END


	SUBROUTINE HOME
	integer term
	COMMON TERM
	IF (TERM.EQ.0)GO TO 100
	if (term.eq.2) go to 200
10	K=ITTOUR("233)
	IF(K.NE.0)GO TO 10
20	K=ITTOUR("110)
	IF(K.NE.0)GO TO 20
	RETURN
100	K=ITTOUR("035)
	IF(K.NE.0)GO TO 100
	DO 120 I=1,4
110	IF(ITTOUR("000).NE.0)GO TO 110
120	CONTINUE
	RETURN
200	if(ittour("033).ne.0) go to 200
210	if(ittour("133).ne.0) go to 210
220	if(ittour("110).ne.0) go to 220
	return
	END

	SUBROUTINE EOS
	integer term
	COMMON TERM
	IF (TERM.EQ.0)GO TO 100
	if (term.eq.2) go to 200
10	K=ITTOUR("233)
	IF(K.NE.0)GO TO 10
20	K=ITTOUR("112)
	IF(K.NE.0)GO TO 20
	RETURN
100	K=ITTOUR("037)
	IF(K.NE.0)GO TO 100
	DO 120 I=1,4
110	IF(ITTOUR("000).NE.0)GO TO 110
120	CONTINUE
	RETURN
200	if(ittour("033).ne.0) go to 200
210	if(ittour("133).ne.0) go to 210
220	if(ittour("112).ne.0) go to 220
	return
	END

	SUBROUTINE EOL
	integer term
	COMMON TERM
	IF (TERM.EQ.0)GO TO 100
	if (term.eq.2) go to 200
10	K=ITTOUR("233)
	IF(K.NE.0)GO TO 10
20	K=ITTOUR("113)
	IF(K.NE.0)GO TO 20
	RETURN
100	K=ITTOUR("036)
	IF(K.NE.0)GO TO 100
	DO 120 I=1,4
110	IF(ITTOUR("000).NE.0)GO TO 110
120	CONTINUE
	RETURN
200	if(ittour("033).ne.0) go to 200
210	if(ittour("133).ne.0) go to 210
220	if(ittour("113).ne.0) go to 220
	return
	END

	SUBROUTINE CURFOR(COL,LIN)
	LOGICAL*1 C1,L1,COL,LIN
	integer term, il1, il10, ic1, ic10
	COMMON TERM
	if (term.eq.2) go to 200
	C1=COL+32
	L1=LIN+32
	IF (TERM.EQ.0)GO TO 100
10	IF(ITTOUR("233).NE.0)GO TO 10
20	IF(ITTOUR("131).NE.0)GO TO 20
30	IF(ITTOUR(L1).NE.0)GO TO 30
40	IF(ITTOUR(C1).NE.0)GO TO 40
	RETURN
100	IF(ITTOUR("016).NE.0)GO TO 100
110	DO 120 I=1,4
115	IF(ITTOUR("000).NE.0)GO TO 115
120	CONTINUE
130	IF(ITTOUR(L1).NE.0)GO TO 130
	DO 140 I=1,4
135	IF(ITTOUR("000).NE.0)GO TO 135
140	CONTINUE
150	IF(ITTOUR(C1).NE.0)GO TO 150
	DO 160 I=1,4
155	IF(ITTOUR("000).NE.0)GO TO 155
160	CONTINUE
	RETURN
200	il1=lin+1
	ic1=col+1
	il10=il1/10
	ic10=ic1/10
	il1=il1-(il10*10)
	ic1=ic1-(ic10*10)
210	if(ittour("033).ne.0) go to 210
220	if(ittour("133).ne.0) go to 220
230	if(ittour(il10+48).ne.0) go to 230
240	if(ittour( il1+48).ne.0) go to 240
250	if(ittour("073).ne.0) go to 250
260	if(ittour(ic10+48).ne.0) go to 260
270	if(ittour( ic1+48).ne.0) go to 270
280	if(ittour("110).ne.0) go to 280
	return
	END


	SUBROUTINE NULL
	integer term
	COMMON TERM
	TYPE	900
	IF(TERM.EQ.0)GO TO 100
	RETURN
100	DO 120 I=1,4
110	IF(ITTOUR("000).NE.0)GO TO 110
120	CONTINUE
	RETURN
900	FORMAT(' ')
	END

                                                                                                     