c
      subroutine plot2 (x,y,ipen)
c
c	PROGRAM NAME:			PLOT2.Rmc
c
c	DATE OF  FIRST  VERSION:	21-Jun-83
c
c	PURPOSE:	PLT pre-processor for calls to move and draw
c			taking into account Tektronix-style output
c
c	USAGE:		call PLOT2 (X,Y,IPEN)
c
c	  Where
c
c             X = X-COORDINATE (REAL)
c             Y = Y-COORDINATE (REAL)
c             IPEN = FUNCTION CODE (INTEGER)
c                  =  +13 = MOVE TO OFFSET/SCALED (X,Y)
c                  =  +12 = DRAW TO OFFSET/SCALED (X,Y)
c                  =   +3 = MOVE TO (X,Y)
c                  =   +2 = DRAW TO (X,Y)
c                  =   -2 = DRAW TO (X,Y), RE-ORIGIN
c                  =   -3 = MOVE TO (X,Y), RE-ORIGIN
c                  =  -12 = DRAW TO OFFSET/SCALED (X,Y), RE-ORIGIN
c                  =  -13 = MOVE TO OFFSET/SCALED (X,Y), RE-ORIGIN
c                  ALL OTHER VALUES IGNORED
c
c	PROGRAMMER:	E. Javel / M. Prucka
c
c******************************************************************
c
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
c...  /PPEP1/ - PPEP PHASE 1 WORKING COMMON BLOCK
      common /ppep1/ ix1,iy1,ix2,iy2,iscan,nscan,nband,nips,nip0,nipm1,
     & lynes,nibsx,msglvl,xdots,ydots,pref(2),rorg(2),port(2,2),iend(4),
     & almt,fact,jpen,xoff,xfac,yoff,yfac,nbits,nbitm1,nbytes,nbytm1,
     & msk,lmsk
c
c----------------------------------------------------------------
c
      if(.not.(x .lt. 0))goto 23000
         type *, 'plot2: x out of bounds.  x,y=',x,y
         goto 23001
c     else
23000    continue
         if(.not.(x .gt. 10.5))goto 23002
            type *, 'plot2: x out of bounds.  x,y=',x,y
23002    continue
23001 continue
      if(.not.(y .lt. 0))goto 23004
         type *, 'plot2: y out of bounds.  x,y=',x,y
         goto 23005
c     else
23004    continue
         if(.not.(y .gt. 7.74))goto 23006
            type *, 'plot2: y out of bounds.  x,y=',x,y
23006    continue
23005 continue
      if(.not.(ipen .eq. 2))goto 23008
         call draw(x, y)
         goto 23009
c     else
23008    continue
         if(.not.(ipen .eq.3))goto 23010
            call move(x, y)
            goto 23011
c        else
23010       continue
            if(.not.(ipen .eq. 12))goto 23012
               call draw(x-xoff, y-yoff)
               goto 23013
c           else
23012          continue
               if(.not.(ipen .eq. 13))goto 23014
                  call move(x-xoff, y-yoff)
23014          continue
23013       continue
23011    continue
23009 continue
      return
      end
                                                                                                                                                                                                                                                                                                                                   