c
c
      function nxtlin (instr)
c
c	PROGRAM NAME:			NXTLIN.rat
c
c	DATE OF  FIRST  VERSION:	 4-Apr-80
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL routine to read the next line from
c			the inut file and determine its type.
c
c	USAGE:	ICMD = NXTLIN (INSTR)
c
c		Where	INSTR -- Input line returned here (byte array)
c
c	PROGRAMMER:	M. Collins / E. Javel / M. Prucka
c*********************************************************************
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
      byteinstr(1),c
      logical*1 err
      external len,index
1     format (1x,72a1)
c
c---------------------------------------------------------------------
c
c Begin by assuming that we'll hit the end of the file
      nxtlin = -1
c Read input lines until we succeed in getting a good one
c     repeat
23000    continue
         call getstr (lunin,instr,72,err)
         if(.not.(err .eq. -1))goto 23003
            return
23003    continue
         call trim (instr)
         nc = len (instr)
c Echo the input line if so desired and if output is not to TI:
         if(.not.(ecflg))goto 23005
            write (5,1) (instr(i),i=1,nc)
c Look for an internal comment and eliminate it from the line.
c If the line so created is blank, ignore it and get another one.
23005    continue
         j = index(instr,';')
         if(.not.(j .ne. 0))goto 23007
            instr(j) = 0
            nc = j - 1
            if(.not.(nc .le. 0))goto 23009
               goto 23001
23009       continue
c Look for an external comment and print it if that hasn't been done.
c Then, eliminate the external comment portion and check to see if
c the elimination resulted in a blank line; if so, ignore it.
23007    continue
         j = index(instr,'!')
         if(.not.(.not.(ecflg) .and. j.gt.0))goto 23011
            write (5,1) (instr(i),i=j,nc-j+1)
23011    continue
         if(.not.(j .ne. 0))goto 23013
            instr(j) = 0
            nc = j - 1
            if(.not.(nc .le. 0))goto 23015
               goto 23001
23015       continue
c Now, figure out how many leading spaces and tabs there are, and
c check to see if there's anything left; if not, get the next line.
23013    continue
c        for
         nb=1
23017    if(.not.(nb.le.nc))goto 23019
            if(.not.(instr(nb).ne.' ' .and. instr(nb).ne."11))goto 23020
               goto 10
23020       continue
             nb=nb+1
            goto 23017
c        endfor
23019    continue
         goto 23001
c It's a real line, so decode the statement type by checking for
c implied statement types:
c Message has a quotation mark
10       if(.not.(index(instr(nb),'"') .ne. 0))goto 23022
            if(.not.(nb .gt. 1))goto 23024
               call scopy (instr(nb),instr)
23024       continue
            nxtlin = 4
            return
c Parameter change has an equals sign
23022    continue
         if(.not.(index(instr(nb),'=') .ne. 0))goto 23026
            if(.not.(nb .gt. 1))goto 23028
               call scopy (instr(nb),instr)
23028       continue
            nxtlin = 3
            return
c Data value has digits, commas, periods, plus and minus signs,
c spaces, or an asterisk.  If any other character exists, the line
c must be a keyword.  If so, eliminate the leading blanks and tabs.
23026    continue
c        for
         i=nb
23030    if(.not.(i.le.nc))goto 23032
            c = instr(i)
            if(.not.(c.gt.'9' .or. (c.lt.'*' .and. c.ne.' ') .or. c.eq.
     &       '/'))goto 23033
               if(.not.(nb .gt. 1))goto 23035
                  call scopy (instr(nb),instr)
23035          continue
               nxtlin = 2
               return
23033       continue
             i=i+1
            goto 23030
c        endfor
23032    continue
c If we get here, it must be a valid data value.  If it's
c more than 30 characters long, eliminate leading blanks and tabs
c until we get down to 30 characters.
         if(.not.(nc-nb .gt. 29))goto 23037
            call scopy (instr(nb),instr,30)
            instr(31) = 0
23037    continue
         nxtlin = 1
         return
23001    goto 23000
      end
                                                                                                                                                                                                                   