c
c
      subroutine numb2 (iax,x,y,height,fpn,angle,ndig)
c
c
c	PROGRAM NAME:			NUMB2.rat
c
c	DATE OF  FIRST  VERSION:	14-Mar-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL modification of Versaplot routine NUMBER
c
c	USAGE:	call NUMB2 (IAX,X,Y,HEIGHT,FPN,ANGLE,NDIG)
c
c		  IAX = Indicates axis being annotated and designates the
c			-2 -- Y-axis, horizontal orientation.  Left-justify
c			      the value and move the character position
c			      downward by half its height.
c			-1 -- Y-axis, vertical orientation.  Process NDIG
c			      as described below.
c			 0 -- X-axis; Process NDIG as described below.
c			>0 -- Y-axis, horizontal orientation.  Generate
c			      this many characters, padding with leading
c			      blanks, and move the character position
c			      downward by half its height.
c		(X,Y) = Starting X,Y coordinates for first character
c	       HEIGHT = Character height in inches
c		  FPN = Number to be plotted
c		ANGLE = Angle to plot the number at (degrees counterclockwise
c			relative to the X-axis)
c		 NDIG = No. of digits and type of string to be plotted.  Values:
c			>0 = Real.  NDIG has no. of digits to right of decimal.
c			-1 = Integer.
c
c	PROGRAMMER:	Eric Javel / Matt Prucka
c
c***********************************************************************
      byte str(26), fmt(4)
      external len
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
1     format(f25.9)
c
c-----------------------------------------------------------------------
c
c See what kind of number we're plotting, and round it
      if(.not.(ndig .lt. 0))goto 23000
c Integer
         fmt(1) = 0
         z = .5
         if(.not.(fpn .ge. 0.))goto 23002
            val = aint (fpn+z)
            goto 23003
c        else
23002       continue
            val = aint (fpn-z)
23003    continue
         goto 23001
c     else
23000    continue
c Real
         fmt(1) = '.'
         fmt(2) = ndig + "60
         z = 5. / 10.**(ndig+1.)
         if(.not.(fpn .ge. 0.))goto 23004
            val = fpn + z
            goto 23005
c        else
23004       continue
            val = fpn - z
23005    continue
23001 continue
c Set the plottable digit count
      ntot = idigts (val,val,fmt)
c Encode the value
      encode (25,1,str,err=10) val
c Look for the first printing character
c     for
      i=1
23006 if(.not.(i.le.25))goto 23008
         if(.not.(str(i) .ne. ' '))goto 23009
            goto 23008
23009    continue
          i=i+1
         goto 23006
c     endfor
23008 continue
c See if need to pad out with leading blanks
      if(.not.(iax .gt. ntot))goto 23011
         i = max0 (i-(iax-ntot),1)
c Terminate the string in the correct place
23011 continue
      if(.not.(ndig .lt. 0))goto 23013
         j = 0
         goto 23014
c     else
23013    continue
         j = ndig + 1
23014 continue
      str(16+j) = 0
      nd=len(str(i))
c If necessary, center the annotation at the tic mark by changing the
c X,Y coordinates sent to "text". The changes made depend on which axis is
c being annotated. If a horizontal Y-axis label is desired, adjust the
c Y-axis position accordingly.
      xz = x
      yz = y
      if(.not.(iax .eq. 0))goto 23015
c X-axis, "normal" orientation
         xz = x - annlen(0,ntot,height)/2.
         goto 23016
c     else
23015    continue
         if(.not.(iax .eq. -1))goto 23017
c Y-axis, "normal" orientation
            yz = y - annlen(0,ntot,height)/2.
            goto 23018
c        else
23017       continue
c Y-axis, horizontal orientation
            yz = y - height/2.
c		xz = x - annlen(str(i),nd,height)+annlen(0,nd,height)
23018    continue
23016 continue
c Plot the string and bug out
      if(.not.(dbflg))goto 23019
         type *,' numb2 -> text'
23019 continue
      call text(xz,yz,height,str(i),angle,nd)
10    return
      end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      