/*
 *			r s o u t . c
 *
 * Output words for rsent.c
 */

#include	<stdio.h>
#include	<ctype.h>
#define	EOS		0
#define	FALSE		0
#define	TRUE		1
#define	LINEWIDTH	70
short		wr_ccpos = 0;
static short	wr_space = FALSE;

wr_word(tp, fildes)
register char	*tp;		/* -> text pointer			*/
FILE		*fildes;
/*
 * Output routine.  Text is output one word at a time, so that the line
 * will not exceed LINEWIDTH bytes.
 *
 * wr_word(NULL, fildes) flushes partial lines.
 *
 * Only blank and newline are acceptable interword separators.
 */
{
	register char	*tstart;	/* -> start of current word	*/
	register short	word_length;	/* Length of word in bytes	*/

	if (tp == NULL) {		/* Flush buffer?		*/
	    if (wr_ccpos > 0) {		/* Yes, in middle of line?	*/
		putc('\n', fildes);
	    }
	    wr_ccpos = 0;
	    wr_space = FALSE;
	}
	else if (*tp == EOS) {		/* Empty input line?		*/
	    wr_space = FALSE;
	}
	else {
	    /*
	     * If at the beginning of an utterance, Capitalize
	     * the first byte if it's a lower-case alphabetic.
	     */
	    if (wr_ccpos <= 0) {
		while (*tp == ' ')
		    tp++;
		if (islower(*tp)) {
		    putc(toupper(*tp++), fildes);
		    wr_ccpos = 1;
		}
		wr_space = FALSE;
	    }
	    /*
	     * Do the rest of the text.  tp -> start of the word or EOS
	     */
	    while (*tp != EOS) {
		if (wr_space) {
		    while (*tp == ' ')
			tp++;
		}
		/*
		 * Locate the end of this word.
		 */
		for (tstart = tp; *tp != EOS && *tp != ' '; tp++)
		    ;
		word_length = (tp - tstart);
		if (wr_space) {		/* Pending space to output?	*/
		    wr_space = FALSE;	/* Not next time around		*/
		    if ((wr_ccpos + word_length) >= LINEWIDTH) {
			putc('\n', fildes);
			wr_ccpos = 0;
		    }
		    else {
			putc(' ', fildes);
			wr_ccpos++;
		    }
		}
		wr_ccpos += word_length;
		while (tstart < tp)
		    putc(*tstart++, fildes);
		if (*tp == ' ') {
		    wr_space = TRUE;
		    while (*tp == ' ')
			tp++;
		}
	    }
	}
}

                      