/*
 * lpr.
 */
#include <stdio.h>
#include <rsx.h>

#define  LPI8	'\006'		/* 8 lines per inch */

int	nflag;
int	rflag;
FILE	*sfp;
char	sfn[40];
char	tb[40];
char	bb[7];
char	pcb[80];
int	nlpi	= 6;
int	nlop	= 60;
int	form	= 0;
int	copies	= 1;
int	pri	= 50;

main(argc, argv)
char *argv[];
{
	register char *p;
	register c, i;
	FILE *fp;
	int nf;

	nf = argc-1;
	for (i=1; i<argc; ++i) {
		p = argv[i];
		if (*p == '-') {
			argv[i] = NULL;
			--nf;
			++p;
			while (c = *p++)
				switch (c) {

				case '8':
					nlpi = 8;
					nlop = 80;
					break;

				case 'b':
				case 'B':
					if (++i >= argc)
						usage();
					banner(argv[i]);
					argv[i] = NULL;
					--nf;
					break;

				case 'c':
				case 'C':
					if (++i >= argc)
						usage();
					copies = atoi(argv[i]);
					if (copies <= 0)
						bad("number of copies");
					argv[i] = NULL;
					--nf;
					break;

				case 'f':
				case 'F':
					if (++i >= argc)
						usage();
					form = atoi(argv[i]);
					if (form < 0 || form > 6)
						bad("form number");
					argv[i] = NULL;
					--nf;
					break;

				case 'l':
				case 'L':
					if (++i >= argc)
						usage();
					nlop = atoi(argv[i]);
					if (nlop <= 0)
						bad("page length");
					argv[i] = NULL;
					--nf;
					break;

				case 'n':
				case 'N':
					++nflag;
					break;

				case 'p':
				case 'P':
					if (++i >= argc)
						usage();
					pri = atoi(argv[i]);
					if (pri < 1 || pri > 250)
						bad("queue priority");
					argv[i] = NULL;
					--nf;
					break;

				case 'r':
				case 'R':
					++rflag;
					break;

				default:
					usage();
				}
		}
	}
	if (nf == 0)
		usage();
	makespool();
	maketitle();
	nf = 0;
	for (i=1; i<argc; ++i)
		if ((p = argv[i]) != NULL) {
			fp = fopen(p, "r");
			if (fp == NULL)
				fprintf(stderr, "%s: not found\n", p);
			else {
				++nf;
				pfile(fp, p);
				fclose(fp);
			}
		}
	if (nf == 0)
		fmkdl(sfp);
	else
		print();
}

banner(p1)
register char *p1;
{
	register char *p2;
	register c;

	p2 = bb;
	while (c = *p1++) {
		if (p2 < &bb[6])
			*p2++ = c;
	}
	*p2 = '\0';
}

pfile(fp, fn)
register FILE *fp;
char *fn;
{
	register c, lop;
	int ln, pn;

	lop = nlop;
	pn = 0;
	ln = 0;
	c = getc(fp);
	for (;;) {
		while (c == '\f') {
			lop = nlop;
			c = getc(fp);
		}
		if (c == EOF)
			break;
		if (lop >= nlop) {
			if (nlpi == 8)
				putc(LPI8, sfp);
			putc('\f', sfp);
			lop = 0;
			if (!rflag) {
				fprintf(sfp, "%s %s Page %d\n\n", tb, fn, ++pn);
				lop = 2;
			}
		}
		if (nlpi == 8)
			putc(LPI8, sfp);
		if (nflag)
			fprintf(sfp, "%d\t", ++ln);
		while (c != EOF && c != '\n' && c != '\f') {
			putc(c, sfp);
			c = getc(fp);
		}
		putc('\n', sfp);
		++lop;
		if (c == '\n')
			c = getc(fp);
	}
}

print()
{
	register char *p1, *p2;
	register s;

	p1 = pcb;
	p2 = "print ";
	while (*p1++ = *p2++)
		;
	--p1;
	if (bb[0] != '\0') {
		p2 = bb;
		while (*p1++ = *p2++)
			;
		p1[-1] = ' ';
	}
	if (form) {
		sprintf(tb, "/fo:%d", form);
		p2 = tb;
		while (*p1++ = *p2++)
			;
		--p1;
	}
	if (pri != 50) {
		sprintf(tb, "/pr:%d", pri);
		p2 = tb;
		while (*p1++ = *p2++)
			;
		--p1;
	}
	*p1++ = ' ';
	*p1++ = '=';
	*p1++ = ' ';
	p2 = sfn;
	while (*p1++ = *p2++)
		;
	--p1;
	if (copies != 1) {
		sprintf(tb, "/co:%d", copies);
		p2 = tb;
		while (*p1++ = *p2++)
			;
		--p1;
	}
	p2 = "/del";
	while (*p1++ = *p2++)
		;
	if ((s = system(pcb)) != IS_SUC)
		fprintf(stderr, "Print/spawn status %d!\n", s);
}

bad(s)
char *s;
{
	fprintf(stderr, "Bad %s.\n", s);
	exit(1);
}

usage()
{
	fprintf(stderr, "Usage: lpr [-8nr] [-b banner] [-c #] [-f #] [-l #]");
	fprintf(stderr, " [-p #] file [file ...]\n");
	exit(1);
}

#include <time.h>

maketitle()
{
	register char *p;

	struct tm	*t;
	int		tvec[2];
/* Warning, time changes untested */
	time(&tvec);
	t = localtime(&tvec);
	p = &"JanFebMarAprMayJunJulAugSepOctNovDec"[3*(t->tm_mon)];
	sprintf(tb, "%02d:%02d %02d-%.3s-%02d",
		t->t_hour, t->t_min, t->t_mday, p, t->t_year);
}

makespool()
{
	register FILE *tfp;
	register v;

	for (v=0; v<100; ++v) {
		sprintf(sfn, "lpr%02d.tmp", v);
		if ((tfp = fopen(sfn, "ru")) == NULL) {
			if ((sfp = fopen(sfn, "w")) == NULL)
				nospool();
			return;
		}
		fclose(tfp);
	}
	nospool();
}

nospool()
{
	fprintf(stderr, "No spool file!\n");
	exit(1);
}
                                                                              