
      SUBROUTINE POSTAP

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  91a16a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Position the magnetic tape.
C
C	Enter a loop and call a routine to read a tape record.  If the
C	the record is a HDR1 record and the saveset name is the desired
C	one, skip over the HDR2 record and the tape mark to the first
C	data record of the saveset, and exit the loop.  If the tape
C	record is not of interest, loop back to read another record.
C
C	If the end of the tape is encountered, set the error flag,
C	display an error message and, exit this subroutine.
C
C
C Edit Record:
C
C	14-Nov-90:  Original creation started.
C	04-Dec-90:  Original creation completed.
C	16-Jan-91:  Module taken from the SVSTDR suite.
C
C
C Calling sequence:
C
C	BtBfLn = <integer>
C	MTDvNm = <string>
C	Read = <integer>
C	SSName = <string>
C	SSNmLn = <integer>
C	CALL POSTAP
C
C
C Returns:
C
C	Error
C
C
C Called By:
C
C	SLSVST
C
C
C Routines Called:
C
C	MTFOR
C
C***********************************************************************

      INCLUDE 'EXTFLS.DAT'		!Common & variables declarations

100   CONTINUE

          CALL MTFOR (MTDvNm,Read,BtBFLn,ByteBf,Iret)

          IF (Iret .EQ. 0) THEN
              CALL MTFOR (MTDvNm,Read,BtBFLn,ByteBf,Iret)
              IF (Iret .EQ. 0) THEN
                  Error = .TRUE.
                  Type *, 'Saveset not found:  ',SSName
                  GOTO 900
              END IF
          END IF

          IF (LblRcd(1:4) .EQ. 'HDR1') THEN
              IF (LblRcd(5:SSNmLn+4) .EQ. SSName(1:SSNmLn)) THEN
                  ! Skip over the HDR2 label record.
                  CALL MTFOR (MTDvNm,Read,BtBfLn,ByteBf,Iret)
                  ! Skip over the tape mark.
                  CALL MTFOR (MTDvNm,Read,BtBfLn,ByteBf,Iret)
                  GOTO 900
              END IF

          ELSE
              ! Simply skip over the record.
          END IF

      GOTO 100

900   CONTINUE
      RETURN
      END				!POSTAP.FOR.
                                                                                                                                                                                                                                                                                                                                                                         