      PROGRAM EXTFLS

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  91f04a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Extract the named files from the selected VMS backup saveset
C	that resides on a magnetic tape, delivering the files to an
C	RT-11 device.
C
C	Call a routine to clear the screen.  Then identify the program
C	and its version.  Call a routine to control the initialization
C	process.  Call a routine to control the extraction of the named
C	files from the selected saveset.  Call a routine to shut things
C	down, neat and clean.  Finally, terminate the program with a
C	parting message.
C
C	If the initialization routine returns an error condition, skip
C	directly to the termination routine call.
C
C
C Edit Record:
C
C	16-Jan-91:  Original creation started.
C	21-Mar-91:  Original creation completed.
C	04-Jun-91:  Revised EXTFLS.DAT and XFRFIL.FOR.
C
C
C Building Requirements:
C
C	The following files are required for building this program:
C
C	Filename	Version		Remarks
C
C	EFCMPL.COM	91c20b	Compile the .FOR modules.
C	EFLINK.COM	91c21a	Link the .OBJ modules.
C	EFMEM.COM	91c20a	Set the memory partition allocation.
C	EXTFLS.COM	91c20a	Command file to build EXTFLS.SAV.
C
C	EXTFLS.DAT	91f04a	COMMON and variables declarations.
C
C	CLRSCR.FOR	91a16a	Clear the screen.
C	EFINIT.FOR	91a16a	Control the initialization process.
C	EFQUIT.FOR	91a16a	Control the termination process.
C	EFWORK.FOR	91c20b	Control the task at hand.
C	EXTFLS.FOR	91f04a	This main control module.
C	GETDIR.FOR	91c20a	Get directory information.
C	GETFIL.FOR	91c21a	Coltrol the transfer of the selected
C				 file.
C	GETFLD.FOR	91c20a	Get a directory data field.
C	GETID.FOR	91c20a	Get a directory data field 
C				 identification number.
C	GETLEN.FOR	91c20a	Get a directory data field length.
C	GETXOR.FOR	91a21a	Get the XOR factor.
C	GTSSNM.FOR	91a24a	Get the saveset name.
C	LSTDIR.FOR	91c21a	List directory data.
C	MNTTAP.FOR	91a16a	Mount the magnetic tape.
C	POSTAP.FOR	91a16a	Position the tape.
C	RDVOL1.FOR	91a16a	Read the VOL1 label record.
C	SELFIL.FOR	91c20b	Select a file to transfer.
C	SLSVST.FOR	91a16a	Select the desired saveset.
C	XFRFIL.FOR	91f04a	Transfer the selected file.
C
C	F77OTS.OBJ		FORTRAN 77 library.
C	MTLIB.OBJ		Magnetic tape subroutine library.
C	SYSLIB.OBJ		System subroutine library.
C
C	F77.SAV			FORTRAN 77 compiler.
C	LINK.SAV		RT-11 linker.
C
C	Copy the files from the distribution media as follows:
C
C		COPY	dev:EXTFLS.DSK	dev:EXTFLS.TMP
C
C	Then unpack the logical device as follows:
C
C		MOUNT	LDx	EXTFLS.TMP
C		CREATE/ALL:yyy	EXTFLS.DSK	      !Where yyy => 988.
C		MOUNT	LDz	EXTFLS.DSK	DK
C		COPY	LDx:	DK:
C		DISMOUNT	LDx
C		DELETE	EXTFLS.TMP
C
C	Build the program EXTFLS.SAV by executing the command file,
C	EXTFLS.COM as follows:
C
C		DISPLAY	:==	TIME		      !For RT-11 only.
C		@EXTFLS.COM
C
C
C Executing Instructions.
C
C	Under RT-11, execute this program as follows:
C
C		ASSIGN	<printer device>	LP
C		ASSIGN	<mag tape device>	MT0
C		LOAD	<mag tape handler>
C		SET	USR	NOSWAP		      !RT11SJ only.
C		RUN	<dev:>EXTFLS
C
C	Under TSX-Plus, execute this program as follows:
C
C		ASSIGN	<printer device>	LP
C		ASSIGN	<mag tape device>	MT0
C		RUN	<dev:>EXTFLS
C
C
C Hiearchical Diagram:
C
C	An asterisk following a module name indicates that there are
C	multiple calls made to the module.  Library routines are
C	identified with comments.
C
C	EXTFLS
C	    CLRSCR
C		PRINT			SYSLIB routine.
C	    EFINIT
C		MNTTAP
C		    MTFOR		MTLIB routine.
C		RDVOL1
C		    MTFOR		MTLIB routine.
C		SLSVST
C		    GTSSNM
C			GTLIN		SYSLIB routine.
C		    POSTAP
C			MTFOR	*	MTLIB routine.
C	    EFWORK
C		MTFOR			MTLIB routine.
C		GETXOR
C		    GETLEN
C		    GETID
C		    GETFLD
C		GETDIR
C		    GETLEN
C		    GETID
C		    GETFLD
C		    LSTDIR
C		SELFIL
C		    GTLIN		SYSLIB routine.
C		GETFIL
C		    XFRFIL
C			MTFOR		MTLIB routine.
C	    SDQUIT
C		MTFOR			MTLIB routine.
C
C
C Routines Called:
C
C	CLRSCR
C	EFINIT
C	EFQUIT
C	EFWORK
C
C***********************************************************************

      INCLUDE 'EXTFLS.DAT'		!Common & variables declarations

      CALL CLRSCR			!Clear the screen.
      TYPE *, ProgID			!Program identification and
      TYPE *				! version.

      CALL EFINIT			!Initialization.
      IF (Error) GOTO 900

      CALL EFWORK			!Perform the task at hand.

900   CONTINUE
      CALL EFQUIT			!Neat and clean.

      TYPE *, Endmsg			!Say we're done.
      TYPE *

      END				!EXTFLS.FOR.
                                                                                                                                                                                                                                                                                                                                                                                   