/* tcpdat.h */

/*
 * Globals for TCP/UDP
 */
#ifdef	GLOBALDATA

char	nnmyaddr[DADDLEN],	/*  my ethernet hardware address */
	broadaddr[DADDLEN],	/*  the broadcast address */	
	nnipnum[4],		/*  my ip number */
	nnredir = 0,		/*  flag indicating need for redirect */
	nnmask[4] =	{0,0,0,0},		/*  the default subnet mask */
	nnamask[4] =	{255,0,0,0},		/* class A mask */
	nnbmask[4] =	{255,255,0,0},		/* class B mask */
	nncmask[4] =	{255,255,255,0},	/* class C mask */
	broadip[4] =	{0xff,0xff,0xff,0xff};

int	nnipident = 1,		/* ident field of outgoing ip packets*/
	nndomto = DOMTIMEOUT,	/* domain timeout */
	nnretry = DOMRETRY,	/* domain retries */
	nnarpto = ARPTIMEOUT,	/* arp timeout */
	nndto = DLAYTIMEOUT,	/* dlayertimeout */
	nnwin = MAXWNDOSIZE,	/* limited window in some cases */
	nnpkt = MAXPCNT,	/* maximum packet count per transq */
	nnseg = MAXSEG,		/* maximum input segment size */
	nnmtu = TMAXSIZE;	/* maximum output segment size */

struct uport ulist;		/* buffer for UDP */
struct pseudotcp tcps;		/* for checksums */
struct acache arpc[CACHELEN];	/* cache for hardware addresses */

ARPKT arp;
DLAYER dblank;
DILAYER ipblank;


struct plist sktlist[LSCKTS];		/* allocate like iobuffers in UNIX */
struct eq nnq[NEVENTS];			/* event queue */
int		nnefirst = 0,		/* first entry in event q */
		nnelast = 0,		/* last entry in event q */
		nnefree = 0;		/* free list for event q */

#else

extern char
	nnmyaddr[DADDLEN],	/*  my ethernet hardware address */
	broadaddr[DADDLEN],	/*  the broadcast address */
	nnipnum[4],		/*  my ip number */
	nnredir,		/*  flag indicating need for redirect */
	nnmask[4],		/*  the default subnet mask */
	nnamask[4],		/* class A mask */
	nnbmask[4],		/* class B mask */
	nncmask[4],		/* class C mask */
	broadip[4];

extern int
	nnipident,		/* ident field of ip */
	nndomto,		/* domain timeout */
	nnretry,		/* domain retries */
	nnarpto,		/* arp timeout */
	nndto,			/* dlayertimeout */
	nnwin,			/* limited window in some cases */
	nnpkt,			/* maximum packet count per transq */
	nnseg,			/* maximum input segment size */
	nnmtu;			/* maximum output segment size */

extern struct uport ulist;		/* buffer for UDP */
extern struct pseudotcp tcps;		/* for checksums */
extern struct acache arpc[CACHELEN];	/* cache for hardware addresses */

extern ARPKT arp;
extern DLAYER dblank;
extern DILAYER ipblank;

extern struct plist sktlist[LSCKTS];	/* allocate like iobuffers in UNIX */
extern struct eq nnq[NEVENTS];		/* event queue */
extern int	nnefirst,		/* first entry in event q */
		nnelast,		/* last entry in event q */
		nnefree;		/* free list for event q */

#endif
                                                                                                                                                                                                                                                                                                                                                                                