/* sktl32.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  sktest
 *
 *  Checks to see if a particular session has been established yet.
 *  Returns 0 if the connection is in "established" state.
 */
int sktest(sknum)
int sknum;
{
	register struct socket *skt;
	long time;

	/*
	 * check validity
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt==-1)
		return(-2);

	if(skt->state==SEST) {
		return(0);
	} else {
		if(skt->state==SCWAIT) {
			if(quedata(&skt->in)) {
				return(0);
			}
			ntclose(sknum);
			time = cticks(NULL);
			while(skt->state==SCWAIT &&
			      elapsed(time) < 300L) {
				ntsleep(0);
				suspnd(0);
			}
		}
	}
	return(-1);
}
                                                               