/* sktl04.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  skread
 *
 *  Read data from the queue buffer (specified by sknum)
 *  into the user buffer for up to n bytes.
 *
 *  Returns number of bytes read or <0 if error.
 */
int skread(sknum,buffer,n)
int sknum,n;
char *buffer;
{
	int i;
	register struct socket *skt;

	/*
	 * check validity
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt==-1)
		return(-2);

	/*
	 * read from queue buffer
	 */
	i = dequeue(&skt->in,buffer,n);

	/*
	 * enter event if more data
	 */
	if(i) {
		if(quedata(&skt->in))
			skptuev(CONCLASS,CONDATA,sknum);

		return(i);
	}

	return(sktest(sknum));
}
                                                                               