/* mailpi.h */

#define NCMDS		38
#define	QMARK		 1
#define BYE		 2
#define COPY		 3
#define DEBUG		 4
#define DELETE		 5
#define DIR		 6
#define EXIT		 7
#define HASH		 8
#define HELP 		 9
#define	HOME		10
#define INDEX		11
#define INTERACTIVE	12
#define	LAST		13
#define LCD		14
#define	LDELETE		15
#define	LDIR		16
#define LIST		17
#define LLS		18
#define	LMKDIR		19
#define LPROTECT	20
#define	LPWD		21
#define	LRENAME		22
#define	LRMDIR		23
#define LTYPE		24
#define LUNPROTECT	25
#define	MAIL		26
#define NEWMAIL		27
#define NONINTERACTIVE	28
#define PROMPT		29
#define QUIT		30
#define READ		31
#define SCAN		32
#define SEND		33
#define STATUS		34
#define USER		35
#define VERBOSE		36
#define	VERSION		37
#define WILD		38

/*
 * RT-11 MAIL
 */
#ifdef	MAILMASTER
#if	  rt$sys
#define	MASTER
char *mail_cmdlist[]={
	"?",
	"bye",
	"copy",
	"debug",
	"delete",
	"directory",
	"exit",
	"hash",
	"help",
	"home",
	"index",
	"interactive",
	"last",
	"lcd",
	"ldelete",
	"ldir",
	"listmail",
	"lls",
	NULL,			/*	"lmkdir",	*/
	"lprotect",
	"lpwd",
	"lrename",
	NULL,			/*	"lrmdir",	*/
	"ltype",
	"lunprotect",
	"mail",
	"newmail",
	"noninteractive",
	"prompt",
	"quit",
	"read",
	"scan",
	"send",
	"status",
	"user",
	"verbose",
	"version",
	"wild"
};
#endif
#endif

/*
 * RT-11 MMAIL
 */
#ifdef	MMAILMASTER
#if	  rt$sys
#define	MASTER
char *mail_cmdlist[]={
	"?",
	"bye",
	"copy",
	"debug",
	"delete",
	"directory",
	"exit",
	NULL,			/*	"hash",		*/
	"help",
	"home",
	"index",
	"interactive",
	"last",
	"lcd",
	"ldelete",
	"ldir",
	"listmail",
	"lls",
	NULL,			/*	"lmkdir",	*/
	"lprotect",
	"lpwd",
	"lrename",
	NULL,			/*	"lrmdir",	*/
	"ltype",
	"lunprotect",
	"mail",
	"newmail",
	"noninteractive",
	"prompt",
	"quit",
	"read",
	"scan",
	"send",
	"status",
	"user",
	NULL,			/*	"verbose",	*/
	"version",
	"wild"
};
#endif
#endif

/*
 * TSX-Plus MAIL
 */
#ifdef	MAILMASTER
#if	  ts$sys
#define	MASTER
char *mail_cmdlist[]={
	"?",
	"bye",
	"copy",
	"debug",
	"delete",
	"directory",
	"exit",
	"hash",
	"help",
	"home",
	"index",
	"interactive",
	"last",
	"lcd",
	"ldelete",
	"ldir",
	"listmail",
	"lls",
	"lmkdir",
	"lprotect",
	"lpwd",
	"lrename",
	"lrmdir",
	"ltype",
	"lunprotect",
	"mail",
	"newmail",
	"noninteractive",
	"prompt",
	"quit",
	"read",
	"scan",
	"send",
	"status",
	"user",
	"verbose",
	"version",
	"wild"
};
#endif
#endif

/*
 * TSX-Plus MMAIL
 */
#ifdef	MMAILMASTER
#if	  ts$sys
#define	MASTER
char *mail_cmdlist[]={
	"?",
	"bye",
	"copy",
	"debug",
	"delete",
	"directory",
	"exit",
	NULL,			/*	"hash",		*/
	"help",
	"home",
	"index",
	"interactive",
	"last",
	"lcd",
	"ldelete",
	"ldir",
	"listmail",
	"lls",
	"lmkdir",
	"lprotect",
	"lpwd",
	"lrename",
	"lrmdir",
	"ltype",
	"lunprotect",
	"mail",
	"newmail",
	"noninteractive",
	"prompt",
	"quit",
	"read",
	"scan",
	"send",
	"status",
	"user",
	NULL,			/*	"verbose",	*/
	"version",
	"wild"
};
#endif
#endif


#ifndef	MASTER
extern
char *mail_cmdlist[];
#endif

/*
 *	The following helpstring text must be
 *	copied to sy: as maicmd.txt
 */

#ifdef	MAICMDTXT
/* maicmd.txt */
	?		print local help information
	bye		terminate the program
	copy		copy a message to a file
	debug		toggle/set debugging mode
	delete		delete a message
	dir		list of unread mail messages
	exit		terminate the program
	hash		toggle printing `#' for each 1024 bytes transferred
	help		print local help information
	home		go to home (initial) directory
	index		an index of received mail
	interactive	turn on prompting for multiple commands
	last		read most recent mail message
	lcd		change local working directory
	ldelete		delete local files
	ldir		list contents of local directory
	listmail	list of unread mail messages
	lls		list contents of local directory
	lmkdir		make a local directory
	lprotect	set protection flag on local file
	lpwd		show local working directory
	lrename		rename a local file
	lrmdir		remove a local directory
	ltype		print a local file to the screen
	lunprotect	clear protection flag on a local file
	mail		go to mail directory
	newmail		count number of new mail messages
	noninteractive	turn off prompting for multiple commands
	prompt		toggle interactive prompting on multiple commands
	quit		terminate the program
	read		read a mail message
	scan		scan directory for all mail messages
	send [filespec]	initiate the sending of a message
	status		show current status
	user		enter a new user/password access key
	verbose		toggle verbose mode
	version		program version displayed
	wild		toggle wildcard expansion of local file names
#endif
                                                                                                                                                                                                                                                                                                                              