/* fmtdat.c */

#include <stdio.h>
#include <string.h>

#include "vt1xx.h"
#include "fmtdat.h"

int	fmttab = 8;		/* Tab spacing */

int	fmtcol = 0;		/* current column position */
int	fmtrow = SCRNBT-SCRNTP;	/* current row    position */

char	fmtbuf[(SCRNBT-SCRNTP+1)*SCRNW];	/* screen image buffer */
int	findex[SCRNBT-SCRNTP+1];		/* screen index array */


/*
	fmtpos	-	Calculate screen column position for
			an arbitrary character position.
*/

int
fmtpos(bf,n) char *bf; int n;
{
register char	c,*p;
register int	i,j,k;

	i = n;
	j = k = 0;
	p = bf;
	while (j++<i) {
		c = *p++;
		if ((c == CRLF) || (c == 0)) { break; }
		if (c == TAB) { k += fmttab-(k%fmttab); }
		else if (c < 32) { k += 2; }
		else { k += 1; }
	}
	return(k);
}


/*
	fmtchar	-	Output a single character to the screen buffer.
*/

VOID
fmtchar(c) char c;
{
register char	*p;

	p = &fmtbuf[0] + findex[fmtrow] + fmtcol;
	*p = c;
}


/*
	fmtplc	-	Format the character string
			into the format buffer.
*/

VOID fmtplc(st,row)
register char *st;
int row;
{
register char	*p;
register char	c;
register int	col,i,j,k,v;

	col = 0;
	j = strlen(st);
	p = &fmtbuf[0] + findex[row];
	for (i=0; i<j; i++,st++) {
		v = *st & REVERSE;
		c = *st & 0x7F;
		if (!c || (c == CRLF)) { break; }
		if (c == TAB) {
			k = fmttab-(col%fmttab);
			if ((col+k) > (SCRNW-1)) { break; }
			col += k;
			while ((k--)>0) { *p++ = ' ' | v; }
		}
		else if (c < 32) {
			if ((col+2) > (SCRNW-1)) { break; }
			col += 2;
			*p++ = '^' | v;
			*p++ = c+64 | v;
		}
		else {
			if ((col+1) > (SCRNW-1)) { break; }
			col += 1;
			*p++ = c | v;
		}
	}
	while (col++ < SCRNW) {
		*p++ = 0;
	}
}


/*
	fmtclr	-	Clear internal screen buffer.
*/

VOID
fmtclr()
{
register char	*p,*q;
register int	i,j,*r;

	p = &fmtbuf[0];
	q = &outbuf[0];
	r = &findex[0];
	for (i=0; i<(SCRNBT-SCRNTP+1); i++) {
		*r++ = i*SCRNW;
		for (j=0; j<SCRNW; j++) {
			*p++ = 0;
			*q++ = 0x7F;
		}
	}
	outclr();
}


/*
	fmtdeol	-	Clear to end of line.
*/

VOID
fmtdeol()
{
register char	*p;
register int	i;

	p = &fmtbuf[0] + findex[fmtrow] + fmtcol;
	for (i=fmtcol; i<SCRNW; i++) {
		*p++ = 0;
	}
}


/*
	fmtsup	-	Scroll region up a single line.
*/

VOID
fmtsup(top,bot) int top,bot;
{
register char	*p,*q;
register int	i,j,k;

	for (j=top, k=bot; j<k ; j++) {
		p = &fmtbuf[0] + findex[j];
		q = p + SCRNW;
		for (i=0; i<SCRNW; i++) {
			*p++ = *q++;
		}
	}
}


/*
	fmtsdn	-	Scroll region down a single line.
*/

VOID
fmtsdn(top,bot) int top,bot;
{
register char	*p,*q;
register int	i,j,k;

	for (j=top, k=bot; j<k ; --k) {
		p = &fmtbuf[0] + findex[k];
		q = p - SCRNW;
		for (i=0; i<SCRNW; i++) {
			*p++ = *q++;
		}
	}
}
                                                                                                                                                                                                                                                             