.comment;sysgen.tsx

.chapter;TSX-Plus System Generation

The TSX-Plus system must be regenerated to provide the necessary
device support, system services, and options required by the
TCP/IP Package.  What follows is a description of each option
that should be examined and updated to allow the proper
operation of the various hardware and software components of the
TCP/IP Package.


.header level 1;BUSTYPE

.note
The DEQNA/DELQA device used by the TCP/IP Package is a QBUS device.
The DEUNA/DELUA device used by the TCP/IP Package is a Unibus device.
.end note

BUSTYP defines the machine bus structure for TSX-Plus.  Their are two
possible machine bus structures supported by TSX-Plus - the QBUS (LSI)
and the UNIBUS.  Select one of these parameters below to specify the
bus support desired.  Use the following information for choosing the
correct bus structure.
.sk 1
QBUS   - 11/23, 11/23-Plus, 11/73, and Professional.
.br
UNIBUS - 11/24, 11/34a, 11/44, and 11/60.
.sk 1
BUSTYP = QBUS	;Specify machine bus structure (UNIBUS/QBUS)
.br

.page
.header level 2;TSGEN Unibus Mapping Modification

A change to the TSX-Plus TSGEN.MAC file is required
to allocate 4 UNIBUS MAPPING REGISTERS for the 22-bit
EU22.TSX driver when used with systems having more than
248. kbytes of addressable memory.

The mapping registers are only required when more than
248. Kbytes of memory are used by TSX-Plus on a Unibus
system.

The following was excerpted from TSGEN.MAC:

.lit
	******************************************************
		;
		;  Generate tables for Unibus map registers
		;
			.GLOBL	UMRBAS,UMREND,UMRWHD
		UMRWHD:	.WORD	0
			.MACRO	UMRDEF	NUM
			.BYTE	CURUMR		;UM$UMR
			.BYTE	NUM		;UM$NMR
		.WORD	NUM*4096.		;UM$WDS
		.WORD	0			;UM$IOQ
	CURUMR	=	CURUMR+NUM
		.ENDM	UMRDEF
	;  Define UMR sets in order of size -- small to large.
	CURUMR	=	5	;Map regs 0-4 always mapped
	UMRBAS:
		.IF	EQ,<BUSTYP-UNIBUS> 	;Generate only
		UMRDEF	1.			;for UNIBUS
		UMRDEF	1.			;machines
		UMRDEF	4.
		UMRDEF	4.
		UMRDEF	8.
		UMRDEF	8.
		.ENDC
	UMREND:
	******************************************************
.end lit

Change the first 'UMRDEF  8.' to 'UMRDEF  4.'
This will free the last 4 UNIBUS MAPPING REGISTERS for use by the
22-bit EU22.TSX driver.


.page
.header level 1;NGR

.note
The TCP/IP Package limits its use to 8. PLAS regions for passing data
and parameters between the network server and the various
client/server tasks.  The number of regions used by each active
client/server program is: TELNET(1), RTELNT(1), FTP(2), FTPL(2), RFTP(2),
MAIL(1), RSMTP(1), RPOP3(1), MMAIL(1), MAILER(1), CNCT(1), RCNCT(1),
RHTTP(1), RGOPH(1), NTSND(1), LPQRM(1), and RLPD(1).
.end note

The number of shared global PLAS regions that can be created by all jobs.
.sk 1
NGR = 20.	;Number of global PLAS regions
.br


.header level 1;DEVXMR

.note
The DEQNA/DELQA/DEUNA/DELUA device handlers use 1 PLAS region.
.end note

Some device handlers allocate extended memory (PLAS) regions for
their use.  For example, the DU and MU handlers each require one
PLAS region. If you are using any other handlers which require
extended memory regions, include the number of regions required.
.sk 1
DEVXMR = 4.	;Number of XM regions for device handlers
.br



.header level 1;IOABT

.note
The TCP/IP Package
Network Server which uses the DEQNA/DELQA/DEUNA/DELUA handlers
internally queue the network requests.
If IOABT is not set to 1 then the Network
Server program cannot be aborted.  This will also be true for the
remote TELNET and CNCT servers which must abort I/O through the CL
device handler.
.end note

The  IOABT parameter controls the action taken by TSX-Plus when
a job terminates execution.  If IOABT=0, TSX-Plus will wait for
all outstanding I/O pending for the job to complete before the job
is actually terminated.  If IOABT=1, TSX-Plus will call the handler
abort entry point for all outstanding I/O pending for the job.
Note, the "SET IO NO ABORT" keyboard command may be used to
change the value of this parameter.
.sk 1
IOABT = 1	;0==>I/O rundown, 1==>I/O abort
.br


.header level 1;DEVDEF

.note
The device handler, EQ.TSX or EU.TSX must be added to the list of system
handlers loaded by TSX-PLUS at system startup.  The handler may
be mapped, uses DMA, and should not allow SET operations on the
loaded handler.
.end note
.sk 1
DEVDEF	<EQ>,DMA,MAPH,NOSET
.br


.header level 1;Message Communication Channels

.note
Each active client/server program of the TCP/IP Package
uses 1 message channel.  Those programs using message channels are:
TCPIP, TELNET, RTELNT, FTP, FTPL, RFTP,
MAIL, RSMTP, RPOP3, MMAIL, MAILER, CNCT, RCNCT,
RHTTP, RGOPH, NTSND, LPQRM, and RLPD.
.end note

Define parameters pertaining to the inter-program
message communication feature.  If this feature is
not wanted, set all four parameters to 0 (zero).

Maximum number of message communication channels
which may be simultaneously in use.
.sk 1
MAXMC	=	10.	;Max message channels
.sk 2
Maximum message length (bytes).
.sk 1
MSCHRS	=	200.	;Max message length (bytes)
.sk 2
Maximum # of messages which may be held in queue.
.sk 1
MAXMSG	=	20.	;Max queued messages
.sk 2
Maximum # of requests for messages that may be held in queue.
.sk 1
MAXMRB	=	10.	;Max # pending message requests

The message length used by TCPIP programs is only 16. bytes.
Thus the MSCHRS term may be changed to '16.' if no other user
programs use the message channels.



.header level 1;Line Definitions

.note
If the remote TELNET or CNCT servers are to be enabled, then a
pair of cross connected serial lines must be added to the
Line#Definition table for each active session.  The following
Line#Definitions illustrate the additions required.  If more than
one pair of lines are added then select sequential time share and
sequential CL lines.  The SILO length definition for the CL line should
be greater than or equal to the maximum number of characters it will
receive in .5 seconds (120 for 2400 baud or 240 for 4800 baud).
This will reduce XON/XOFF sequences and maximize the serial transfer rate.
.end note

.literal
; The TBLDEF macro call requires four arguments:
;   1. The number of real time-sharing lines on machine.
;   2. The number of subprocess jobs.
;   3. The number of detached jobs.
;   4. The number of dedicated CL lines.

TBLDEF	3.,10.,6.,1.	;# Real, # Subprocess,
			;# Detached, # CL lines

; #3 time-sharing line is cross linked to CL0:
	LINDEF	340,175600
	CMDFIL	LINE3.TSX
	TRMTYP	VT100
	FLAGS	NRMFLG
	LINEND

; CL0: is cross linked to #3 time-sharing line
	CLDEF	0,350,175610
	SILO	256.,12.,4.
	CLEND
.end literal


.header level 1;DETACH

.note
The command file DETACH.TSX is used to startup the Network Server.
.end note

Use the "DETACH" macro here to declare any start-up command
files and associated parameters (up to 80 characters) to be
run as detached jobs:
.sk 1
DETACH	<SY:DETACH.TSX> 	;Start-up detached job
.br


.header level 1;Record Locking

.note
If the MAIL, RSMTP, MMAIL, MAILER, RPOP3, or RLPD programs are
to be used then record locking is necessary to properly update
the mail/lprint sequence files.
.end note

Define parameters pertaining to record (block) locking
for shared files.  If the shared file block locking
facility is not wanted, set all of these parameters to
0 (zero).

Maximum number of shared files which may be open
simultaneously.  Note that several users accessing the same
file count as 1.
.sk 1
MAXSF	=	4.	;Max number of shared files
.sk 2
Maximum number of I/O channels which all users may
simultaneously have open to shared files.
Note, this is the total number for all users not
for each user.
.sk 1
MAXSFC	=	16.	;Max # shared file channels
.sk 2
Maximum number of blocks which may be simultaneously
held locked by any channel.  That is, max blocks
locked per channel.
.sk 1
MXLBLK	=	16.	;Max blocks locked per channel


.header level 1;User Command Linkage

.note
The file TCP:TSXUCL.INS contains over 40 UCL definitions, however
a typical user may require only a few of them.
.end note

U$CL is a flag that controls whether the User Command Linkage is to
be used to allow users to define their own commands.
If U$CL is non-zero the UCL facility is enabled and users may define
their own system commands. If U$CL is zero, user defined commands
will not be supported by the system. Note: if the UCL facility is
enabled, the TSXUCL.SAV file must be placed on the system disk.
.sk 1
U$CL	=	1	;0==>No UCL program
.br
#			;1==>UCL program
.sk 2
Number of user-defined commands that can be stored by TSXUCL
for each job. (The number of blocks required in the SY:TSXUCL.DAT file
is approximately equal to the number of commands per job times the
total number of time-sharing lines divided by 5).
.sk 1
UCLMNC	=	12.	;Maximum user-defined
.br
#			;commands per job
                                                                                                                                                    