.comment;build.tsx

.chapter;Building the TCP/IP Package

.header level 1;C Compiler

The DECUS C Compiler and Assembler and the RT-11 Macro Assembler and Linker
are required to build the the TCP/IP Package for TSX-Plus from the
source files included in the distribution.  The DECUS C Compiler is
from the DECUS 11-SP-18 distribution with bug fixes made to
the compiler and the library.  (The updates are on logical disk CCDSK2.DSK).
EIS and non-EIS versions of the compiler along with the assembler,
library, and the necesary header files are included with the
distribution to allow the package to be recompiled.
The CC.SAV files were modified by the TSX-Plus
SETSIZ program to allow it to use an extended program space of 64Kb.

.list
.list element;Create CDISK.DSK[1500] as C:,
.br
a logical disk for the C compiler
.list element;Copy the contents of the logical disk CCDSK1.DSK
to C:. The device containing the compiler, assembler and header files should
be assigned as device C:. The build procedures assume that the
compiler and header files are on the logical device 'C:'.
.list element;Copy the compiler helper files from logical disk
CCXDSK.DSK to C:.
.list element;Use the command file C:CCSET.EIS to copy the
EIS specific files into the C: directory with the appropriate .SAV
and .OBJ file types.
.list element; Copy the command files C:CC.TSX and C:ASM.TSX
as CC.COM and ASM.COM to the system device.  These TSX-Plus
command files are used to invoke the C compiler and AS assembler.
.end list


.header level 1;TCP/IP Package

The TCP/IP Package is supplied with the complete source code as an
assemblage of C files (*.c), macro files (*.mac), header files (*.h),
and an assortment of command files (*.com).

.list
.list element;Copy the logical disks SRDSK1.DSK, SRDSK2.DSK,
SRDSK3.DSK, and SRDSK4.DSK to a disk or logical disk having
at least 10000 blocks of free space.
.list element;Use the command file BLDTSX.SET to create the TSX-Plus
conditional files.
.list element;The command file BLDALL.COM will compile and link
the complete TCP/IP Package.  Inspect BLDALL.COM to see how each
individual component is built.  An unloaded 11/73 processor will take from
40 to 50 minutes to compile and link the complete package.
.list element;Rename all .SAV files to .STV files.
.list element;The file TSX.INS may be used to copy all the files necessary to
configure a complete implementation of the TCP/IP Package for TSX-Plus
to the TCP: directory.
(This includes all the files found on logical disks TSDSK1.DSK,
TSDSK2.DSK, and TSDSK3.DSK).
.end list

.header level 1;Compiling Options

The TCP/IP Package components may be compiled with or without the
diagnostic options (the default is no diagnostics).  Each component
has an individual header file, e.g. VTCPIP.H for TCPIP.SAV, which
contains define statements that have been commented out to exclude
the diagnostics.  Several other programs have optional sections
that may be disabled by commenting out selected define statements.
        