C --------------------------------------
C RDMCOM - internal common area for RDM Access Routines
C		NOTE: not needed for (well behaved) F77 application 
C
	Integer*2 Maxfile,	!maximum number of files open at once
	1	  Maxfld,	!maximum number of fields (all files)
	2	  Maxmap	!maximum number of map files open
	Parameter (Maxfile=10, Maxfld=60, Maxmap=2)! use even numbers here
	INTEGER*4 xRnum(Maxfile),!number of data records in file
	1         xSnum(Maxfile),!number of sorted records in file
	2	  recno(Maxfile),!current record number in RDM file.(start=1)
	3	  mrcno(Maxmap),!physical record(element) number in map file
	4	  mRnum(Maxmap)	!number of records(elements) in map file
	INTEGER*2 Hnum(Maxfile),!number of header blocks in RDM file
	1	  Rsize(Maxfile),!size in bytes of data records
	2         RecDef(Maxfld,5),!array of maximum fields/record-
C				! 1st subscript (1..Maxfld)=
C				!   corresponds to field dictionary seq. #
C				! 2nd subscript= 1: holds field type
C				!		 2: offset in record
C				!		 3: length of field
C				!		 4: # of elemnts in array
C				!		 5: next dictionary record #
	3	  recptr,	!current offset of record in current RDM block
	4	  mrcptr,	!current element offset current map file blk.
	5	  blkno,	!current block number in RDM file
	6	  mblkno,	!current block number in map file
	7	  oldblk,	!last retrieved RDM file block number
	8	  oldmbk,	!last retrieved map file block number
	9	  Curfil,	!current file being used
	1	  Curmap,	!current map file being used
	2	  Fldofs(Maxfile),!offset in field table for this file
	3	  Nfiles,	!number of active RDM files
	4	  Nfields,	!number of active fields
	5	  Nmaps		!number of active Map files
C
	BYTE	  sort(3,Maxfile)!sort order of RDM file.
C				!  1st subscript= field # of Primary sort key
C				!		  1: in dictionary
C				!		  2: implied sort
C				!         (if primary is RECORD, first field)
C				!		  3: number of open map files
	BYTE	  Msort(Maxmap),!  Primary sort field of Map
	1	  block(512),	!contents of a READ on RDM file
	2	  mblock(512),	!contents of a READ on map file
	3	  DicTab(Maxfld)! field number for dictionary record(i)
	LOGICAL	  mapped(Maxfile)! =.TRUE. if using a map file
	CHARACTER*14 RDMnam(Maxfile)	!Rdm File names
	Logical*1 Indexed(Maxfile)!necessary starting w/ version 4
	Integer*2 ichan(Maxfile),!internal channel for file & block locking
	1	  Units(Maxfile),!unit numbers for files
	2	  Mapunit(2,Maxmap), !unit numbers of file associated with map
C				!       1: unit number for map
C				!	2: unit number for file
	3         Access(Maxfile)!File protection =
C				!		    0: Read ONLY
C				!		    1: Shared
C				!		    2: Exclusive 
	Integer*2 tsxblk	!Block number for tsx block locking
C
	COMMON /rdmcom/ xRnum,xSnum,Rsize,RecDef,sort,mapped,mRnum,
	1		block,mrcno,recno,mblock,Hnum,oldblk,oldmbk,ichan,
	3		Access,tsxblk,fldofs,Curfil,Nfiles,Nfields,
	4		Dictab,Units,Curmap,Nmaps,Msort,Mapunit,Indexed
	COMMON /rdmstr/ RDMnam
C
                                               