/*
 *				c o s h . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION
title	cosh	hyperbolic cosine function
index	hyperbolic cosine function
usage
	.s
	double x, f, cosh();
	.br
	f = cosh(x);
	.s
description
	.s
	Returns hyperbolic cosine of argument.
	.s
diagnostics
	.s
	If the argument is large enough to cause overflow in the result
	the message 'cosh arg too large', followed by the argument,
	is written to stderr. A value of HUGE is returned.
	.s
internal
	.s
	Algorithm from pp. 217-238 of Cody and Waite.  The constant v which
	appears in 2 define statements is chosen so that log(v) is an exact
	octal constant slightly larger than log(2) (See C and W pp. 218 and
	227.
	.s
author
	.s
	Hamish Ross.
	.s
date
	.s
	12-Jan-85
#endif

#include <math.h>

#define WMAX 88.0265309203708668	/* internal overflow limit	*/
#define CON1 0.6931610107421875		/* log(v)			*/
#define CON2 0.138302778796019026e-4	/* v / 2 - 1			*/

double cosh(x)
double x;
{
    double y, exp();

    y = x < 0.0 ? -x : x;
    if (y > LOG_HUGE) {
	y -= CON1;
	if (y > WMAX) {
	    cmemsg(FP_COSH, &x);
	    return(HUGE);
	}
	y = exp(y);
	y += CON2;
    }
    else {
	y = exp(y);
	y = 0.5 * (y + 1.0 / y);
    }
    return(y);
}
                                                                                                                                                                                                                                                                            