
C  include constant definition if not defined
C	The functions below are used in implementation of the basic PP
Cinstruction set. These subroutines perform low level functions and
Cwould not normally be called by a user program.
C	In the descriptions that follow, the integer variable ISTS
Creturns the status of the operation and its value may be one of
Cthe following:
C
C	SUCCES : The specified function was successful and the PP echoed
C		 the READY ('>') code on completion of the function.
C	FAIL :	 The specified funtion was executed by the PP, however
C		 the function failed and the PP returned FAILURE ('F').
C		 NOTE: this return does not necessarily indicate a serious
C		 error in either the PP or the host computer, e.g.,
C		 the subroutine BLANK will return FAIL if the PROM being
C		 tested caontained programmed bits.
C	PPERR :  This error should not occur under normal operation, and
C		 may indicate a serious error. This value will be returned
C		 if the PP returned a value of '?' in response to a command.
C		 This may indicate that the PP received a command that it
C		 could not understand. After a PPERR occurs, the user
C		 should call the subroutine ERRSTS to both reset the
C		 error condition and to determine what error occured.
C	RCVERR : This error indicates the host detected a data receive
C		 error. This can occur if there was a UART buffer
C		 overflow, a UART framing error, or a receiver buffer
C		 input overflow in the host driver software. This error
C		 should never occur under normal conditions
C	HEXERR : Illegal hex value
C###############################################################################
C
      SUBROUTINE PPXR ( COMAND, HEXARG, LENEXP, REPLY, ISTS )
C
C###############################################################################
C	This function accepts an arbitrary length command string COMAND
C(which must be terminated with a null byte not a CR) that will be sent
Cto the PP. Before transmitting a command to the PP, the routine can transmit
Can argument, HEXARG, which is a random length ASCII hex byte string. The
Cinteger variable LENEXP specifies the number of ASCII hex bytes that the PP
Cexpects to receive as an argument to the command. If the length of HEXARG
Cis less than LENEXP, then HEXARG must be terminated with a null byte, and PPXR
Cwill adjust the length of the string HEXARG to match the number of ASCII hex
Ccharacters expected by the PP function by left filling the string with
C'0's. If the PP function does not accept an argument, then LENEXP should
Cbe set to 0 and only COMAND will be transmitted.
C	After the command string is transmitted, the routine waits for a one
Cline response from the PP. This response is stored in the LINBUF which is
Cdimensioned as LINMAX bytes long. If more than one line is transmitted
Cfrom the PP to the host then this routine cannot be used. The one record
Ctransmitted by the PP is copied into the random length string REPLY and
Cit is terminated with a null byte. REPLY does not return a CR or a LF or
Cany of the status codes, i.e.  SUCCES-'>', FAILURE-'F' or ERROR-'?'.
C###############################################################################
      BYTE COMAND ( 1 ), HEXARG ( 1 ), REPLY ( 1 )
      BYTE HEXTMP ( 6 ), PPLIN, HEXBIN
      INTEGER LENEXP, ISTS, SHIFT
      IF (.NOT.( LENEXP .GT. 0 )) GOTO 20000
      CONTINUE
       LEN = 0
20002 IF (.NOT.( LEN .LE. 4)) GOTO 20004
      IF (.NOT.( HEXARG ( LEN + 1 ) .EQ. 0 )) GOTO 20005
      GOTO 20004
20005 CONTINUE
20003 LEN = LEN + 1 
      GOTO 20002
20004 CONTINUE
      CALL COPY ( HEXARG, HEXTMP, LEN + 1 )
      IF (.NOT.( LENEXP .GT. LEN )) GOTO 20007
      L = SHIFT ( HEXTMP, 1, LENEXP - LEN )
      CONTINUE
       I = 1
20009 IF (.NOT.( I .LE. LENEXP - LEN)) GOTO 20011
      HEXTMP ( I ) = '0'
20010 I = I + 1 
      GOTO 20009
20011 CONTINUE
20007 CONTINUE
      IF (.NOT.( .NOT. HEXBIN ( HEXTMP, IVAL ) )) GOTO 20012
      ISTS = - 3
      RETURN
20012 CONTINUE
      CALL PPX ( HEXTMP, LENEXP )
20000 CONTINUE
      CALL PPXLIN ( COMAND, LENGTH ( COMAND ) )
      IF (.NOT.( .NOT. PPLIN ( REPLY, 132, LEN ) .OR. LEN .EQ. 0 )) 
     $GOTO 20014
      ISTS = - 1
      RETURN
20014 CONTINUE
      IF (.NOT.( REPLY ( LEN ) .EQ. '>' )) GOTO 20016
      ISTS = 1
      GOTO 20017
20016 CONTINUE
      IF (.NOT.( REPLY ( LEN ) .EQ. 'F' )) GOTO 20018
      ISTS = 0
      GOTO 20019
20018 CONTINUE
      ISTS = - 2
20019 CONTINUE
20017 CONTINUE
      REPLY ( LEN ) = 0
      RETURN
      END

C
      SUBROUTINE PPXBEG
C
C###############################################################################
C	This subroutine sends the appropriate START code to the prom programmer.
CThe start code precedes data transfers in a COMPARE (PPCMP) or an INPUT (PPINP)
Coperation and the code is determined by the data translation format (XFORMAT).
C###############################################################################
      CALL PPX ( 2, 1 )
      RETURN
      END

C
      SUBROUTINE PPXEND
C
C###############################################################################
C	PPXEND transmits the nonprintable end code that is used to terminate
Cdata transmission to the prom programmer in either the COMPARE (PPCMP) or
Cthe INPUT (PPINP) commands. Also, the programmer employs a look-ahead procedure
Cto optimize some operations. However, this is undesirable in this application,
Cand to bypass the look-ahead, 16 DELETE bytes are sent to force the programmer
Cto send status of the previous PPINP or PPCMP operation back to the host
Cimmediately.
C###############################################################################
      BYTE DELETS ( 16 )
      DATA DELETS / 16 * 127 /
      CALL PPX ( 3, 1 )
      CALL PPX ( DELETS, 16 )
      RETURN
      END

C
      SUBROUTINE SENDPP ( COUNT, COMAND, DATA, ISTS )
C
C###############################################################################
C	This function is called by the CMPM2R (compares DATA to PP RAM) and the
CINDATA (writes DATA to PP RAM) subroutines to write a command instruction
Cto the PP and then write an array of data. This function writes the following
Cinformation to the PP and in the order listed.
C
C 1) The 4 byte ascii string COUNT which is a count of the number of bytes
C    of memory that are to be programmed or to be compared, (i.e. the #
C    character bytes in the vector DATA divided by two).
C	THIS FUNCTION MODIFIES THE BLOCK SIZE, AND SETS IT EQUAL TO COUNT
C 2) The random length instruction string COMAND is transmitted to the PP.
C 3) The data transmit start code
C 4) DATA a vector of ascii hex characters to be written/compared to memory
C    starting at address which is set by the BEGRAM subroutine. COUNT bytes
C    of memory are written/compared.
C 5) The data transmit stop code
C
C	The function returns status in the integer status parameter ISTS.
CISTS can return SUCCES, FAIL, HEXERR, PPERR or RCVERR.
C###############################################################################
      BYTE COUNT ( 4 ), DATA ( 1 ), HEXBIN
      BYTE COMAND ( 1 ), PPLIN
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      IF (.NOT.( .NOT. HEXBIN ( COUNT, ICNT ) )) GOTO 20020
      ISTS = - 3
      RETURN
20020 CONTINUE
      NCHARS = ICNT * 2
      CALL BLKSIZ ( COUNT, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20022
      RETURN
20022 CONTINUE
      CALL PPXLIN ( COMAND, LENGTH ( COMAND ) )
      CALL PPXBEG
      LINBUF ( 3 ) = ','
       I = 1
20024 IF (.NOT.( I .LE. NCHARS)) GOTO 20026
      LINBUF ( 1 ) = DATA ( I )
      LINBUF ( 2 ) = DATA ( I + 1 )
      CALL PPX ( LINBUF, 3 )
20025 I = I + 2 
      GOTO 20024
20026 CONTINUE
      CALL PPXEND
      IF (.NOT.( .NOT. PPLIN ( LINBUF, 132, LEN ) .OR. LEN .NE. 1 )) 
     $GOTO 20027
      ISTS = - 1
20027 CONTINUE
      IF (.NOT.( LINBUF ( 1 ) .EQ. 'F' )) GOTO 20029
      ISTS = 0
      GOTO 20030
20029 CONTINUE
      IF (.NOT.( LINBUF ( 1 ) .EQ. '>' )) GOTO 20031
      ISTS = 1
      GOTO 20032
20031 CONTINUE
      ISTS = - 2
20032 CONTINUE
20030 CONTINUE
      RETURN
      END

C
      INTEGER FUNCTION IPPTOK ( NULINE, TOKEN )
C
C###############################################################################
C	Routine to read lines from the PP and to parse the lines into tokens.
CIn response to an output data instruction, the PP returns data in a line
Cby line fashion. Each line is no more than the number of characters specified
Cby the record size (see the set record size instruction appendix page 3-7
Cof the PP instruction manual). Lines of data are returned by the subroutine
CPPLIN, and each line returned is terminated by a null byte.
C	The only argument that must be specified to the subroutine is the byte
Cvariable NULINE. If NULINE is true, then this forces the subroutine to accept
Ca new line from the PP before parsing the next token. If NULINE is false, then
Cparsing will continue with the current line in the input buffer. When required
Chowever, the function will read a new line.
C	The random length byte string TOKEN will return the next token and it
Cis terminated by a null byte. There are three types of tokens returned by the
Csubroutine, and each type is indicated by the function value return:
C	The last sequence to be sent from the PP is the checksum, after which
Cthe PP sends the status byte, FAILURE, READY or ERROR.
C
C	IPPTOK   |   description
C	---------|-------------------------------------------------------------
C	ADDRESS  |   string TOKEN returns a 4 byte string that is an ASCII hex
C	         |   address in the format: HHHH<EOS> (where H is a hex digit).
C	CHECKSUM |   string TOKEN returns 5 byte string which is in the format:
C	         |   HHHH<EOS>  where HHHH is a four byte hex checksum.
C	FAIL     |   PP did not understand command, etc. the function failed
C	         |   to be executed by the PP
C	HEXDATA  |   TOKEN returns a two byte ASCII hex data word.
C	RCVERR   |   PPLIN retruned a status indicating a serious error
C	PPERR    |   if PP returns a FAILURE code, '?'.
C###############################################################################
      BYTE LINBUF ( 132 ), PPLIN, NULINE
      BYTE TOKEN ( 1 )
20033 CONTINUE
      IF (.NOT.( NULINE .OR. LINBUF ( LINPNT ) .EQ. 0 )) GOTO 20036
      IF (.NOT.( .NOT. PPLIN ( LINBUF, 132, LEN ) )) GOTO 20038
      ipptok = ( - 1 )
      RETURN
20038 CONTINUE
      LINPNT = 1
      IF (.NOT.( LEN .LT. 10 )) GOTO 20040
      IDS = INDEX ( LINBUF, '$' )
      IF (.NOT.( IDS .GT. 0 )) GOTO 20042
      LINPNT = LEN + 1
      CALL COPY ( LINBUF ( IDS + 2 ), TOKEN, 5 )
      IF (.NOT.( LINBUF ( IDS + 1 ) .EQ. 'S' )) GOTO 20044
      IF (.NOT.( .NOT. PPLIN ( LINBUF, 132, LEN ) .OR. LEN .NE. 1 )) 
     $GOTO 20046
      ipptok = ( - 1 )
      RETURN
20046 CONTINUE
      IF (.NOT.( LINBUF ( 1 ) .EQ. 'F' )) GOTO 20048
      ipptok = ( 0 )
      RETURN
20048 CONTINUE
      IF (.NOT.( LINBUF ( 1 ) .EQ. '>' )) GOTO 20050
      ipptok = ( 11 )
      RETURN
20050 CONTINUE
      ipptok = ( - 2 )
      RETURN
20051 CONTINUE
20049 CONTINUE
20047 CONTINUE
      GOTO 20045
20044 CONTINUE
      ipptok = ( 10 )
      RETURN
20045 CONTINUE
20042 CONTINUE
20040 CONTINUE
20036 CONTINUE
      IF (.NOT.( LINBUF ( LINPNT ) .EQ. ',' )) GOTO 20052
      LINPNT = LINPNT + 1
      GOTO 20034
20052 CONTINUE
      CALL COPY ( LINBUF ( LINPNT ), TOKEN, 3 )
      LINPNT = LINPNT + 2
      ipptok = ( 12 )
      RETURN
20034 GOTO 20033
20035 CONTINUE
      END

                                                                                                                                                                                                                                          