program exmmap;

var memadd, exmadd, staadd, exsadd, fndflg: integer;

procedure testmemory;
   begin
(*$C
	mov	@#4,-(sp)		;remove system trap handler
	mov	@#6,-(sp)
	mfps	@#6			;leave psw unchanged
	mov	#^O172300,r0		;turn on memory management
	clr	r1
enmmgt:	mov	r1,^O40(r0)		;install relocation address
	mov	#^O77406,(r0)		;activate this page
	add	#^O200,r1
	add	#2,r0
	cmp	r0,#^O172320
	bcs	enmmgt
	mov	memadd(r5),r0		;get address lo
	mov	#^O172346,r1
	mov	exmadd(r5),(r1)		;map bank 3
	mov	#^O7600,@#^O172356	;map I/O page
	mov	#1,@#^O177572
	clr	fndflg(r5)
	mov	#tstmem,@#4		;install our trap handler
	br	tstme2
tstmem:	add	#4,sp			;restore stack
	add	#2,r0
	bpl	tstme2
	sub	#^O20000,r0		;relocate bank 3
	add	#^O200,(r1)
	cmp	(r1),#^O10000		;all done?
	bcc	tstme4
tstme2:	tst	(r0)			;get first location
	inc	fndflg(r5)
	mov	r0,staadd(r5)		;starting address
	mov	(r1),exsadd(r5)
	mov	#tstme6,@#4
	br	tstme3
tstme5:	tst	(r0)			;get last location
tstme3:	add	#2,r0
	bpl	tstme5
	sub	#^O20000,r0		;relocate bank 1
	add	#^O200,(r1)
	cmp	(r1),#^O10000		;all done?
	bcs	tstme5
	br	tstme4
tstme6:	add	#4,sp			;restore stack
tstme4:	clr	@#^O177572	;turn off memory management
	mov	r0,memadd(r5)
	mov	(r1),exmadd(r5)
	mov	(sp)+,@#6	;restore system trap handler
	mov	(sp)+,@#4
*)
   end;

procedure writeadd(add, exadd: integer);
   begin
   exadd:=exadd+add div 100B and 177B;
   write(chr(ord('0')+exadd div 1000B and 7));
   write(chr(ord('0')+exadd div 100B and 7));
   write(chr(ord('0')+exadd div 10B and 7));
   write(chr(ord('0')+exadd and 7));
   write(chr(ord('0')+add div 10B and 7));
   write(chr(ord('0')+add and 7))
   end;

begin
writeln('
EXMMAP 128KW Extended Memory Mapper
Andromeda Systems Incorporated

    From       To    Words    Vectors   Description
   ------    ------   ----   ---  ---   -------------------------------');
memadd:=60000B; exmadd:=0;
   repeat
   testmemory;
   if fndflg<>0 then
      begin
      write('   '); writeadd(staadd, exsadd);
      write(' .. '); writeadd(memadd, exmadd);
      if exsadd<7600B then
         write((exmadd-exsadd) div 40B
            +(memadd-staadd) div 4000B and 3: 6,
            'K              MEM11/MSV11 memory')
      else
         begin
         write((exmadd-exsadd) * 40B
            +(memadd-staadd) div 2: 6, '. ');

if staadd=60150B then
   write('  420..434   IBV11-A instrument bus interface') else
if (staadd>=67700B) and (staadd<70000B) then
   repeat
   write('   ?    ?    DRV11 parallel line unit');
   staadd:=staadd+10B;
   if (staadd<memadd) and (staadd<70000B) then write('
                           ')
   until (staadd>=memadd) or (staadd>=70000B) else
if staadd=70400B then
   write('  400  404   ADC11/ADV11 A/D converter') else
if staadd=70420B then
   write('  440  444   PRTC11/KWV11 real time clock') else
if (staadd>=70440B) and (staadd<70500B) then
   write('             DAC11/AAV11 D/A converter') else
if staadd=70700B then
   write('  170  174   DFDC11 floppy disk') else
if (staadd>=71400B) and (staadd<71500B) then
   write('             DIO11 parallel interface') else
if (staadd=72300B) or (staadd=72340B) or (staadd=77640B) then
   write('             KT11 memory management') else
if (staadd>=72410B) and (staadd<72440B) then
   write('  124        DRV11-B DMA interface') else
if staadd=72516B then
   begin
   write('             KT11 memory management');
   if memadd>72520B then write('
                             224        TM11 magnetic tape')
   end else
if staadd=72520B then
   write('  224        TM11 magnetic tape') else
if staadd=73000B then
   write('             PROM11/BDV11 bootstrap ROM') else
if staadd=74400B then
   write('  160        RL01 hard disk') else
if (staadd>=76500B) and (staadd<76700B) then
   repeat
   write('   ?    ?    MSI11/DLV11 serial interface');
   staadd:=staadd+10B;
   if (staadd<memadd) and (staadd<76700B) then write('
                           ')
   until (staadd>=memadd) or (staadd>=76700B) else
if staadd=77170B then
   write('  264        FDC11/RX01/RX02 floppy disk') else
if staadd=77200B then
   write('             MDC11 mini-floppy disk') else
if staadd=77400B then
   write('  220        RK05 hard disk') else
if (staadd>=77510B) and (staadd<77520B) then 
   begin
   if staadd=77510B then write('  204  200')
   else write('  200     ');
   write('   MSI11P/LPI11/LPV11 line printer');
   if memadd>77520B then write('
                                        BDV11 diagnostic')
   end else
if staadd=77520B then
   write('             BDV11 diagnostic') else
if staadd=77546B then
   write('  100        BDV11 line time clock') else
if staadd=77560B then
   write('   60   64   MSI11/DLV11 console terminal') else
if staadd=77572B then
   write('  250        KT11 memory management') else
if staadd=77776B then
   write('             KDF11 processor status register')

         end;
      writeln
      end
   until exmadd=10000B
end.
                                                