C	COPY/DEVICE/FILE FOR RT-11 V3B.
C
C	PROGRAM:	COPDEV
C
C	AUTHOR:		B. CLARK
C			ATMOSPHERIC ENVIRONMENT SERVICE
C			4905 DUFFERIN STREET,
C			CITY OF NORTH YORK,  ONTARIO
C				M3H 5T4
C
C	WRITTEN:	12-JAN-82
C
C	PURPOSE:	TO PERFORM THE RT-11 V4 EQUIVALENT OF
C			COPY/DEVICE/FILE XXX:AAABBB.CCC YYY:DDDEEE.FFF
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
	BYTE		 ANSWER
	INTEGER		 BLK
	INTEGER*2	BUFF(256)
	INTEGER*2	CBLK(4)
	INTEGER*2	 DEFTYP(4)
	INTEGER*2	 FILSPC(39)
	INTEGER*2	OPTION(4,1)
	BYTE		LINE(81)
	BYTE		STAR(2)
	BYTE		SURE(23)
	DATA	DEFTYP/3RDEV,3RDEV,0,0/
	DATA	OPTION(1,1)/'I'/
	DATA	STAR/'*',"200/
	DATA	SURE/' ',' ',' ',':','/','C','o','p','y',
	1 ' ','a','r','e',' ','y','o','u',' ','s','u','r','e','?'/
C
C
C	GET INPUT FROM TERMINAL OR FROM COMMAND FILE
C
	CALL GTLIN(LINE,STAR)
	CALL ASSIGN(5,'TT:',3,'NEW','CC',1)
	IRET=ICSI(FILSPC,DEFTYP,LINE,OPTION,1)
	IF(IRET .EQ. 0) GOTO 250
	IF(IRET .EQ. 1) STOP 'Illegal command'
	IF(IRET .EQ. 2) STOP 'Illegal device spec'
	IF(IRET .EQ. 3) STOP 'Illegal or too many option(s)'
250	CONTINUE
	IRET=IFETCH(FILSPC(1))
	IF(IRET .NE. 0) STOP 'No such OUT device'
	IRET=IFETCH(FILSPC(16))
	IF(IRET .NE. 0) STOP 'No such IN device'

C
C
C	ARE YOU SURE?? ONLY ASKED IF THE OUTPUT IS DEV: ONLY,
C	THAT IS, NON FILE-STRUCUTRED AS INDICATED BY /I OPTION.
C
	IF(OPTION(2,1) .EQ. 0) GOTO 500
	FILSPC(2)=0
	FILSPC(3)=0
	FILSPC(4)=0
C
	CALL R50ASC(3,FILSPC(1),SURE(1))
C
	TYPE 100,SURE
100	FORMAT('$',23A1)

	READ(5,110) ANSWER
110	FORMAT(1A1)

	IF(ANSWER .NE. 'Y'
	1	.AND.
	2ANSWER .NE. 'y') STOP

C
C
C	OPEN FILES NOW
C
C
500	CONTINUE
	IIN =LOOKUP(2,FILSPC(16))
	IF(IIN  .LT. 0) STOP 'Bad LOOKUP'
	CBLK(4)=IIN
	IF(IIN .EQ. 0) CALL IDSTAT(FILSPC(16),CBLK)
	IOUT=IENTER(1,FILSPC(1),CBLK(4),-1)
	IF(IOUT .LT. 0) STOP 'Bad IENTER'
C
C
C
	BLK=0		!START AT BLOCK NUMBER 0
C
C
C
1000	CONTINUE
	IRET=IREADW(256,BUFF,BLK,2)
	IF(IRET .EQ. -1) GOTO 2000		!END-OF-FILE
	IF(IRET .EQ. -2) STOP 'H/W error IN'
	IF(IRET .EQ. -3) STOP 'Channel IN'
C
C
	IRET=IWRITW(256,BUFF,BLK,1)
	IF(IRET .EQ. -1) STOP 'OUT full'
	IF(IRET .EQ. -2) STOP 'H/W error OUT'
	IF(IRET .EQ. -3) STOP 'Channel OUT'
C
C
	BLK=BLK+1	!NEXT BLOCK
	IF(BLK .NE. CBLK(4)) GOTO 1000
C
C
C
2000	CONTINUE
	TYPE 200,BLK
200	FORMAT(1X,I6,' Blocks transferred')
	CALL CLOSEC(1)
	CALL CLOSEC(2)
	CALL EXIT
	END
                                                                                                               