/*+
 * BOOL gsubs (srcstr, ipos, sepch, resstr, lstr)
 *    TEXT  *srcstr, *sepch, *resstr;
 *    COUNT *ipos;
 *    COUNT lstr;
 *
 * Description  : Routine to get a substring out of a string starting at
 *                a given position and ending with the first occurrance
 *                of the separating character.
 *                Leading and trailing spaces are deleted.
 *                If the first and last characters of the result string
 *                are quotes then the quotes are omitted; this is the
 *                only way to get leading and trailing spaces in the
 *                result string.
 *
 * Arguments    : srcstr = String containing source-string
 *                ipos   = input:
 *                            Integer - position in SCRSTR where RESSTR starts
 *                         output:
 *                            Integer - position plus 1 of separating char
 *                            in SRCSTR, or
 *                            position of end-of-string character (=zero byte)
 *                sepch  = String containing the separating character
 *                resstr = String receiving the result-string
 *                lstr   = Integer - the maximum number of characters placed
 *                         into RESSTR
 *                gsubs  = Boolean - end of string flag:
 *                          0  - normal return
 *                         -1  - end of string detected
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V2.0      Date : 12-jan-1983
 *
 * Module name  : GSUBS.FOR
 *
 * Package      : RT11-LIBRARY
 *
 * Updates      : name                 version
 *
 *  description : R. Beetz             V2.0
 *                .no maximum in RESSTR
 *                .LSTR argument added
 *                .quote handling
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : gsubs.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/

#include <local.h>

BOOL gsubs (srcstr, ipos, sepch, resstr, lstr)
    TEXT  *srcstr, *sepch, *resstr;
    COUNT *ipos;
    COUNT lstr;

    {
    FAST COUNT n1, n2;

    BOOL ieos;

    ieos = FALSE;
    *resstr = NULL;
    n2 = n1 = *ipos;
/*
 *    Search for Seperating Character
 */
    FOREVER
        {
        if(srcstr[n2] == *sepch)
            {
            *ipos = n2 + 1;
            ieos = FALSE;
            break;
            }
        else if(srcstr[n2] == NULL)
            {
            *ipos = n2;
            ieos = TRUE;
            break;
            }
        else
            {
            ++n2;
            }
        }
/*
 *    Trim Leading Spaces
 */
    while(srcstr[n1] == ' ')
        {
        if(n1 > n2)
            {
            return(ieos);
            }
        ++n1;
        }
/*
 *    Trim Trailing Spaces
 */
    for(; srcstr[n2] == ' '; --n2);
/*
 *    Quote Handling
 */
    if(n1 != n2  &&  srcstr[n1] == '"'  &&  srcstr[n2] == '"')
        {
        ++n1;
        --n2;
        }
/*
 *    Copy Result
 */
    cpybuf(resstr, srcstr+n1, min(n2-n1, lstr));
    resstr[min(n2-n1, lstr)] = NULL;
    return(ieos);
    }
                      