	.IF P1 NE "?" .GOTO BEGIN
; USRCHK.CMD
;
; Subroutine command file to check privilege and/or CLI
;
; SYNTAX:	@LB:[1,2]USRCHK name/cli PRIV	! from other than LB:[1,2]
;		@/LB:USRCHK name/cli PRIV	! from LB:[1,2] .CMD files
;		name	identifying prefix for error messages
;		/cli	CLI required
;		PRIV	present if privilege required
;
; If /cli is present, $CLI will contain the name of the CLI at entry.
;
; Assumes file #0 not open (used for error message)
.; P.J.Spencer, Capricornia Electricity Board, Rockhampton, Qld, AUSTRALIA
	.EXIT		! after 	@USRCHK ?
.BEGIN:	.ONERR 0ERR
	.SETT SUBS
	.ENABLE GLOBAL 
	.IFENABLED SUBSTITUTION .GOTO 10
	.SETF SUBS
	.ENABLE SUBSTITUTION
.10:
	.PARSE P1 "/" NAM RCLI
	.IF P2 EQ "" .GOTO 40		! privilege not checked
	.IF P2 EQ "NOPRIV" .GOTO 40
	.IFT <PRIVIL> .GOTO 40
	.GOSUB 1ERR Privilege violation
.40:
	.IF RCLI EQ "" .GOTO 60		! no requested CLI
	.SETS $CLI <CLI>
	.IF <CLI> EQ RCLI .GOTO 60	! have requested CLI
	.SETS MCR "MCR"
	.IF $CLI = "MCR" .SETS MCR ""
	'MCR' SET /CLI=TI:'RCLI'
	.IFDISABLED MCR	.GOTO 60	! debugging run
.50:	.IF <CLI> EQ RCLI .GOTO 60	! setting worked
	.GOSUB 1ERR Cannot set CLI to 'RCLI'
.60:
	.IFF SUBS .DISABLE SUBSTITUTION
	.EXIT <SUCCES>
.1ERR:	.OPEN TI:
	.DATA 'NAM' -- 'COMMAN'
	.DATA
	.CLOSE
	.DISABLE DISPLAY
	.STOP <ERROR>
.0ERR:
	.DISABLE QUIET
;
; Privilege violation or CLI not set
;
	.STOP <ERROR>
                                                                                                        