{$Y-,W-}
program nbs_preprocessor;

{Author : Earl Chew
Date    : 11-JUNE-83
}

const
  _include = "#include";
  _paslib  = "#paslib";
  _library = "#library";
  _module  = "#module";
  _end     = "#end";

type
  commands = (include_, paslib_, library_, transfer_, module_, end_);
  relation = (LT,LE,EQ,GE,GT,NE);

const
  progid = "PRE";
  nul = chr(0);
  space = ' ';
  tab = chr(9);
  output_default = "PAS";
  include_default = "P";
  command_sign = '#';
  command_end = ';';
  library_default = "PLB";
  pascal_library = "PASCAL";

const
 stringlength = 30;

type
  string = array [1..stringlength+1] of char;

var
  null : string;
  inp, out:text;

function compare(src1:string; comparison:relation; src2:string):boolean;external;

procedure warn(prognam,msg:string); external;

procedure inform(prognam,msg:string); external;

procedure fatal(prognam,msg:string); external;

procedure lowercase(var ch:char); external;

procedure process_command(var f:text; action:commands; var arg:string);

procedure getword(var f:text; var w:string);

var
  i : integer;

begin
  while not eof(f) and ((f@=space) or (f@=tab) or eoln(f)) do
    get(f);
  if eof(f) then begin
    warn(progid, "Missing command argument terminator");
    w := null
  end
  else begin
    i := 1;
    while not(eoln(f) or (f@=space) or (f@=tab) or (f@=command_end)) do begin
      read(f, w[i]);
      lowercase(w[i]);
      if i<=stringlength then
	i := i + 1
    end;
    w[i] := nul
  end
end;

procedure command(var f:text; var w:string);

var
  arg:string;
begin
  if compare(w,EQ,_include) then
    process_command(f,include_,arg)
  else if compare(w,EQ,_paslib) then
    process_command(f,paslib_,arg)
  else if compare(w,EQ,_library) then begin
    getword(f,arg);
    process_command(f,library_,arg)
  end
  else if compare(w,EQ,_module) then
    process_command(f,module_,arg)
  else if compare(w,EQ,_end) then
    process_command(f,end_,arg)
  else begin
    warn(progid,null);
    writeln('Illegal command : ','''',w,'''')
  end;
  readln(f)
end;

procedure transfer(var f:text);
var
  word:string;
begin
  while not eof(f) do begin
    if f@<>command_sign then begin
      while not eoln(f) do begin
	out@:=f@;
	put(out);
	get(f)
      end;
      writeln(out);
      readln(f)
    end
    else begin
      getword(f, word);
      command(f, word)
    end
  end
end;

procedure include(var f:text);
var
  inp:text;
  fname,word:string;
begin
  getword(f, fname);
  while compare(fname, NE, null) do begin
    reset(inp,fname,include_default);
    process_command(inp, transfer_, null);
    getword(f, fname)
  end
end;

procedure library(var f:text; var fname:string);
var
  inp:text;
  mname,word:string;
  found,finished:boolean;

begin
  reset(inp,fname,library_default);
  getword(f, mname);
  while compare(mname, NE, null) do begin
    reset(inp, null);
    found:=false;
    while not (found or eof(inp)) do begin
      while not((inp@=command_sign) or eof(inp)) do
        readln(inp);
      if not eof(inp) then begin
        getword(inp,word);
        if compare(word,EQ,_module) then begin
	  getword(inp,word);
	  found:=compare(word,EQ,mname)
        end;
        readln(inp)
      end
    end;
    if not found then begin
      inform(progid,null);
      writeln('Library : ''',fname,'''     Module : ''',mname,'''');
      fatal(progid,"Search failed for abovenamed module")
    end
    else begin
      finished:=false;
      while not(finished or eof(inp)) do
        if inp@<>command_sign then begin
	  while not eoln(inp) do begin
	    out@:=inp@;
	    put(out);
	    get(inp)
	  end;
	  writeln(out);
	  readln(inp)
        end
        else begin
	  getword(inp,word);
	  if compare(word,EQ,_end) then begin
	    finished:=true;
	    getword(inp,word);
	    if compare(word,NE,mname) then begin
	      warn(progid,null);
	      writeln('Mismatching #end in module ''',mname,'''')
	    end
	  end
	  else if compare(word,EQ,_module) then begin
	    finished:=true;
	    warn(progid,null);
	    writeln('Missing #end in module ''',mname,'''');
	  end
	  else
	    command(inp,word)
        end;
      if not finished then begin
        warn(progid,null);
        writeln('Unterminated module ''',mname,'''')
      end
    end;
    getword(f, mname)
  end
end;

begin {process_command}
  case action of
    include_ : include(f);
    library_ : library(f,arg);
    paslib_  :  begin
      arg:=pascal_library;
      library(f,arg)
    end;
    transfer_ : transfer(f);
    module_, end_ : fatal(progid,"Library module in source file")
  end
end;

begin {main}
  null := "";
  rewrite(out, argv[3]@, output_default);
  reset(inp, argv[2]@, include_default);
  process_command(inp, transfer_, null)
end.
                                                                                                                                                                                                 