c
c
      function indata (x,y,z,n,max,instr)
c
c
c	PROGRAM NAME:			INDATA.rat
c
c	DATE OF  FIRST  VERSION:	 4-Apr-80
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLT routine to decode one data value.
c
c	USAGE:	ISTAT = INDATA (X,Y,Z,N,MAX,INSTR)
c
c		Where X,Y,Z  -- Real*4 data arrays
c			  N  -- Entry in X,Y,Z of last data value
c			MAX  -- Maximum size of X,Y,Z
c		      INSTR  -- Byte array that holds the first input line
c
c		      ISTAT  -- Exit status:
c				  -1 = Error in datum decode
c				   0 = Data entered OK
c				   1 = Data entered OK, but buffer is
c					full with more data to come
c
c		 * denotes single datum, entered from keyboard
c		** denotes multiple data, entered from keyboard
c
c	PROGRAMMER:	Eric Javel / Matt Prucka
c
c*********************************************************************
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
      real*4x(1),y(1),z(1)
      logical*1err,multi,keybd
      byteinstr(1)
      externallen,index
1     format (
     & ' *** Input multiple data. Terminate with blank line ***'/)
2     format (' *** Please wait while data are plotted ***')
3     format ('$Enter X,Y [,Z]: ')
4     format (3f10.0)
5     format (' Illegal Datum: ',50a1)
c
c-----------------------------------------------------------------------
c
c See if user wants data value input from the keyboard
      multi = .false.
      keybd = .false.
      i = index(instr,'*')
      if(.not.(i .ne. 0))goto 23000
         keybd = .true.
         if(.not.(index(instr(i+1),'*') .ne. 0))goto 23002
c Multiple data, maybe
            multi = .true.
            write (5,1)
23002    continue
c Test for buffer full
23000 continue
10    if(.not.(n .ge. max))goto 23004
         indata = 0
         if(.not.(multi))goto 23006
c Restore multiple data flag
            call scopy ('**',instr)
            write (5,2)
            indata = 1
23006    continue
         return
c Get the line from the keyboard if we need to do that
23004 continue
      if(.not.(keybd))goto 23008
         write (5,3)
         call getstr (5,instr,79,err)
         if(.not.(len(instr) .eq. 0))goto 23010
c Blank line, so ignore input
            indata = 0
            return
23010    continue
c Decode the data line
23008 continue
      nc = len (instr)
      instr(nc+1) = ','
      decode (30,4,instr,err=20) a,b,c
      n = n + 1
      x(n) = a
      y(n) = b
      z(n) = c
      if(.not.(multi .and. keybd))goto 23012
c Get more if mult. data from keyboard
         goto 10
23012 continue
      indata = 0
      return
c Error in decode
20    write (5,5) (instr(i),i=1,nc)
      if(.not.(multi .and. keybd))goto 23014
c Get more if mult. data from keyboard
         goto 10
23014 continue
      indata = -1
      return
      end
                                                  