C PROGRAM TO PRINT OUT 1ST 32 BYTES OF EACH BLOCK IN FILE.
C
C          NASA DFRF
C          P.O. BOX 273
C          EDWARDS, CA   93523
C 
C COMPILE AS FOLLOWS: 
C 
C  .FORTRA DEVDMP
C 
C LINK AS FOLLOWS:
C 
C  .LINK DEVDMP
C 
      INTEGER*2 ISPEC(39),JSWI(4,2),JBUF(256)
	BYTE IBUF(512)
      REAL*4 EXT(2) 
	EQUIVALENCE (IBUF(1),JBUF(1))
      DATA EXT/6RSAVLST,6RDATDAT/
      DATA JSWI/'W',3*0,'B',3*0/,IDIF/0/
C
C CALL COMMAND STRING INTERPRETER TO GET DEVICE NAMES.
C  *TT:=DK:FILE.NAM
C   WHERE FILE.NAM IS A FILE TO BE SEARCHED AND PRINTED.
C    'NAM' IS 'SAV' BY DEFAULT.
C 
    5 IF(ICSI(ISPEC,EXT,,JSWI,2).NE.0) GO TO 5
C ASSIGN LOGICAL UNIT 10 TO 1ST OUTPUT FILE ENTERED. 
      CALL IASIGN(10,ISPEC(1),ISPEC(2),0,0)
C GET A CHANNEL NUMBER. 
      ICHAN=IGETC() 
      IF(ICHAN.LT.0) STOP 'NO CHANNEL'
C FETCH INPUT DEVICE HANDLER INTO MEMORY. 
      IF(IFETCH(ISPEC(16)).NE.0) STOP 'BAD FETCH' 
C PERFORM LOOKUP OF INPUT FILE. 
      I=LOOKUP(ICHAN,ISPEC(16)) 
C IF BAD LOOKUP, GO TO 50.
      IF(I.LT.0) GO TO 50
C INITIALIZE BLOCK NUMBER OF INPUT FILES.
      IBLK=0
C READ A BLOCK.
   10 I=IREADW(256,IBUF,IBLK,ICHAN)
C IF END OF FILE REACHED, END PROGRAM.
      IF(I.EQ.-1) GO TO 9999
C IF BAD READ, GO TO 51.
      IF(I.LT.-1) GO TO 51
C INITIALIZE BYTE COUNT.
      INUM=0
C
C MASK OFF PARITY BIT.
      DO 24 J=1,16
	JBUF(J)=IAND(JBUF(J),"077577)
24	CONTINUE
C COMPARE WORDS IN BLOCK.
      DO 25 J=1,32
	IF(IBUF(J).LT."40.OR.IBUF(J).GT."176) IBUF(J)='.'
25	CONTINUE
C
	WRITE(10,109)IBLK,(IBUF(J),J=1,32)
109	FORMAT(1X,I6,' *',32A1,'*')
C
      IBLK=IBLK+1
      GO TO 10
C
   50 WRITE(10,100)I
  100 FORMAT(I7)
      STOP 'BAD LOOKUP'
   51 WRITE(10,101)I
  101 FORMAT(1X,I7,'BAD READ')
 9999 STOP
      END
                                                                                                                                                                                                                                                      