/*
 * RSX11M V3.2 System Definition Headers for C.
 *
 * Window Definition Block  ( WDBDF$ )
 *
 * Used with 'craw', 'elaw', 'map', 'umap', 'sref' and 'rref'
 * functions.
 *
 * Bob Denny
 * 12-May-80
 *
 */

struct	wdb	{
		char	w_nid;		/* Window ID */
		char	w_napr;		/* Base APR # */
		ADDR	w_nbas;		/* Virtual base addr. */
		int	w_nsiz;		/* Window size */
		int	w_nrid;		/* Region ID */
		int	w_noff;		/* Offset in part. */
		int	w_nlen;		/* Length to map */
		int	w_nsts;		/* Window status word */
		ADDR	w_nsrb;		/* Send/Rec buf. virtual
					   address */
		};

/* Window Status Word Symbols */

#define	WS_CRW	0100000	/* Address Window succ. created */
#define	WS_UNM	0040000	/* Windows unmapped in CRAW or MAP */
#define	WS_ELW	0020000	/* Windows eliminated in CRAW or MAP */
#define	WS_RRF	0010000	/* Reference successfully received */
#define	WS_64B	0000400	/* 64 byte alignment allowed */
#define	WS_MAP	0000200	/* Map after CRAW or rec. by ref. */
#define	WS_RCX	0000100	/* Exit if no ref's to receive */
#define	WS_DEL	0000010	/* Send with delete access */
#define	WS_EXT	0000004	/* Send with extend access */
#define	WS_WRT	0000002	/* Send or map with write access */
#define	WS_RED	0000001	/* Send with read access */
                                                                                                                                                                                                                                                                       