/*
 *				c s j o i n . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	csjoin		Compute Join (Union) of Two Csets
index			Compute join (union) of two csets

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 CSET *
	 csjoin(cs1,cs2);
	 CSET *cs1;
	 CSET *cs2;

description

	The cset returned by csjoin() has as members all elements of either
	cs1 or cs2.  Whenever possible, csjoin() shares existing data by
	returning a cset that shares the memory used by cs1 and cs2.  This
	is most likely to occur if very few calls to cset() (or other cset
	functions that allocate new csets) occured between the calls that
	created cs1 and cs2.

	If csunique is true, a new cset is always formed.

	csjoin() returns NULL if it couldn't allocate a cset to return.

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=03
 * Edit history
 * 0.0 16-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif
#define NULL	0

CSET *
csjoin(cs1,cs2)
CSET *cs1;
CSET *cs2;
{	register CSET *newcs;
	register int i;

	if ( (((int)cs1 & 1) == 0)		/* cs1 not complemented	*/
	  && (((int)cs2 & 1) == 0)		/* cs2 not complemented */
	  && (cs1->table == cs2->table)		/* Shared table		*/
	  && !csunique )			/* No forced copy	*/
	{	if ((newcs = (CSET *)malloc(sizeof(CSET))) != NULL)
			copy((char *)newcs,(char *)cs1,sizeof(CSET));
						/* Duplicate cs1 desc.	*/
			newcs->mask |= cs2->mask;
						/* Or the masks		*/
	}
	else					/* All new...		*/
		if ((newcs = cset("")) != NULL)
		{	for (i = 0; i < cssize; i++)
				if (csmember(cs1,i) || csmember(cs2,i))
					newcs->table[i] |= newcs->mask;
		}

	return(newcs);
}
                                                                                                                                                                                                                                                                                                              