
C  include constant definition if not defined
C###############################################################################
C	Definitions of constants used in the PP software
C###############################################################################
C###############################################################################
C	Codes that are used in initialization of the prom programmer
C###############################################################################
C###############################################################################
C	Function code returns from the PP
C###############################################################################
C###############################################################################
C	Codes returned by HOST PP subroutines
C###############################################################################
C
C
C   	Please refer to the 'SYSTEM 19 UNIVERSAL PROGRAMMER 990-1902
C   INSTRUCTION MANUAL'.
C
C	pages                 |   topic
C	----------------------|----------------------------------------
C	APPENDIX 2-1 to 2-4   |   data translation formats
C	APPENDIX 3-1 to 3-8   |   remote control operation and command summary
C	3-8 to 3-9            |   detailed error description
C#############################################################################
C
      SUBROUTINE PRMINI
C
C##############################################################################
C	Prom programmer power-up initialization routine. This routine also
Cdetermines if the PP was previously set-up in the computer mode, and if it
Cwas, then the user does not have to enter commands to the PP to enable
Ccomputer control
C##############################################################################
      BYTE BITE, PPLIN, SETPCR
      INTEGER PPIN
20000 CONTINUE
      CALL PPMINI
      CALL PPX ( 27, 1 )
      CONTINUE
       I = 1
20003 IF (.NOT.( I .LE. 10000)) GOTO 20005
      ISTS = PPIN ( BITE )
      IF (.NOT.( ISTS .NE. 0 )) GOTO 20006
      GOTO 20005
20006 CONTINUE
20004 I = I + 1 
      GOTO 20003
20005 CONTINUE
      IF (.NOT.( BITE .NE. '>' )) GOTO 20008
      CALL PUTL ( ' ', 5 )
      CALL PUTL ( '	* enter prom programmer command ', 5 )
      CALL PUTL ( ' 	KEYBD  SELECT  F  1  START', 5 )
      CALL PUTL ( '$			(return when done): ', 5 )
      READ ( 5, 100 )
100   FORMAT ( A10 )
      CONTINUE
       I = 1
20010 IF (.NOT.( I .LE. 10000)) GOTO 20012
      ISTS = PPIN ( BITE )
      IF (.NOT.( ISTS .NE. 0 )) GOTO 20013
      GOTO 20012
20013 CONTINUE
20011 I = I + 1 
      GOTO 20010
20012 CONTINUE
20008 CONTINUE
      IF (.NOT.( ISTS .EQ. - 1 )) GOTO 20015
      CALL BELL
      CALL PUTL ( ' ** data receive error, try again', 5 )
      GOTO 20001
20015 CONTINUE
      IF (.NOT.( ISTS .EQ. 0 )) GOTO 20017
      CALL BELL
      CALL PUTL ( ' ** time out error, try again', 5 )
      CALL PUTL ( '    is serial line unit cable connected?', 5 )
      GOTO 20001
20017 CONTINUE
      IF (.NOT.( BITE .NE. '>' )) GOTO 20019
      CALL BELL
      WRITE ( 5, 30 )
30    FORMAT ( ' ** initialization error, try again' )
      GOTO 20001
20019 CONTINUE
      CONTINUE
       I = 1
20021 IF (.NOT.( I .LE. 32000)) GOTO 20023
20022 I = I + 1 
      GOTO 20021
20023 CONTINUE
      CONTINUE
20024 CONTINUE
      ISTS = PPIN ( BITE )
      IF (.NOT.( ISTS .EQ. 1 .AND. ( BITE .EQ. 13 .OR. BITE .EQ. 10 ) )
     $) GOTO 20027
      GOTO 20025
20027 CONTINUE
      GOTO 20026
20028 CONTINUE
20025 GOTO 20024
20026 CONTINUE
      IF (.NOT.( ISTS .EQ. - 1 )) GOTO 20029
      CALL BELL
      WRITE ( 5, 30 )
20029 CONTINUE
      IF (.NOT.( SETPCR ( ) )) GOTO 20031
      GOTO 20002
20031 CONTINUE
20001 GOTO 20000
20002 CONTINUE
      RETURN
      END

C
      BYTE FUNCTION PREADY ( )
C
C###############################################################################
C	After certain commands, the expected response will be a READY ('>')
Ccharacter and a CR and a LF. This routine reads the next line of input data
Cand returns true if the characters read were as listed, else it returns false.
C###############################################################################
      BYTE BITE, PPLIN
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      IF (.NOT.( .NOT. PPLIN ( LINBUF, 132, LINLEN ) .OR. LINLEN .NE. 1
     $ .OR. LINBUF ( 1 ) .NE. '>' )) GOTO 20033
      pready = ( . FALSE . )
      RETURN
20033 CONTINUE
      pready = ( . TRUE . )
      RETURN
20034 CONTINUE
      END

C
      BYTE FUNCTION SETPCR ( )
C
C###############################################################################
C	This function sends commands to the prom programmer and sets the
Ccommunication protocol and determines the PP characteristics. This
Cfunction must be included as part of initialization. If there
Care no errors, the function returns true, else it returns false.
C###############################################################################
      BYTE BITE, PPLIN, PREADY
      INTEGER EQUAL
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      LEN = LENGTH ( '0U' )
      CALL PPXLIN ( '0U', LEN )
      IF (.NOT.( .NOT. PREADY ( ) )) GOTO 20035
      CALL BELL
      WRITE ( 5, 40 )
40    FORMAT ( ' ** bad handshake from PP, reinitialize' )
      setpcr = ( . FALSE . )
      RETURN
20035 CONTINUE
      LEN = LENGTH ( '53A' )
      CALL PPXLIN ( '53A', LEN )
      IF (.NOT.( .NOT. PREADY ( ) )) GOTO 20037
      CALL BELL
      WRITE ( 5, 40 )
      setpcr = ( . FALSE . )
      RETURN
20037 CONTINUE
      CALL PPXLIN ( '=', 1 )
      IF (.NOT.( .NOT. PREADY ( ) )) GOTO 20039
      CALL BELL
      WRITE ( 5, 40 )
      setpcr = ( . FALSE . )
      RETURN
20039 CONTINUE
      CALL PPXLIN ( 'G', 1 )
      LEN = LENGTH ( '3599>' )
      IF (.NOT.( .NOT. PPLIN ( LINBUF, 132, LINLEN ) .OR. LINLEN .NE. 
     $LEN .OR. .NOT. EQUAL ( LINBUF, '3599>' ) )) GOTO 20041
      CALL BELL
      CALL PUTL ( ' ** invalid software configuration, reinitialize', 5
     $ )
      setpcr = ( . FALSE . )
      RETURN
20041 CONTINUE
      setpcr = ( . TRUE . )
      RETURN
      END

C
      SUBROUTINE BELL
C
C###############################################################################
C	Writes a bell to the terminal
C###############################################################################
      WRITE ( 5, 100 ) 7, 7
100   FORMAT ( 2a1 )
      RETURN
      END

C
      BYTE FUNCTION SPPIN ( BITE )
C
C###############################################################################
C	This function performs a synchronous read from the PP. It waits until
Ceither a character has been received, or an error has occured. If an error
Coccured, the function returns false, else it returns true, and the character
Cwill be returned in the byte variable BITE.
C###############################################################################
      INTEGER PPIN
      BYTE BITE
20043 CONTINUE
      ISTS = PPIN ( BITE )
      IF (.NOT.( ISTS .EQ. - 1 )) GOTO 20046
      sppin = ( . FALSE . )
      RETURN
20046 CONTINUE
20044 IF (.NOT.( ISTS .EQ. 1 )) GOTO 20043
20045 CONTINUE
      sppin = ( . TRUE . )
      RETURN
      END

C
      BYTE FUNCTION PPLIN ( LINE, MAXLIN, LINLEN )
C
C###############################################################################
C	PPLIN is a function used to input a single record of data from the
Cprom programmer. This routine operates synchronously, i.e. it will only
Creturn to the calling routine when a line of data has been received.
CThe function will return true if no error occured, else it will return
Cfalse and the line length will be zero.
C	The vector to receive the input line is stored in the byte
Cvector LINE which is at most MAXLIN characters. MAXLIN must be specified
Cby the calling routine.
C	When the function returns a line of data, the line will be terminated
Cwith a null byte, and the carriage return, line feed will be removed. The
Cinteger parameter LINLEN will return the actual number of bytes contained
Cin the input vector LINE, not counting the null byte.
C	NOTE: because the null byte requires one byte, the maximum number
Cof bytes that will be stored in LINE is MAXLIN-1.
C	If the input vector is too small, an error will be generated and
CLINE will be filled with as many bytes as will fit. On the next call
Cto the subroutine, the remainder of the input record (or as much as
Cwill fit in LINE) will be returned, until the entire record has been read in.
C	If a serious data receive error is detected, (circular buffer overflow,
Cor a UART error) the function will return false, and the LINE will be
Creturned with LINLEN=0 and LINE(1)=EOS.
C	Also, this routine is written to interface with ASCII character
Ctransmission only, (NOT BINARY DATA FORMATS, however, many other routines
Cincluding the driver will work with either binary or formatted ascii
Ccharacter formats). Therefore since null bytes are meaningless, they are
Cfiltered out by this routine. Also, if a totally blank line is recieved,
Cit is ignored, (e.g. a line consisting only of null bytes).
C###############################################################################
      BYTE SPPIN, BITE, LINE ( MAXLIN )
      INTEGER LINLEN, MAXLIN
      LINLEN = 0
20048 IF (.NOT.( SPPIN ( BITE ) )) GOTO 20049
      IF (.NOT.( BITE .EQ. 0 )) GOTO 20050
      GOTO 20048
20050 CONTINUE
      IF (.NOT.( BITE .EQ. 10 .AND. LINLEN .GT. 0 )) GOTO 20052
      pplin = ( . TRUE . )
      RETURN
20052 CONTINUE
      IF (.NOT.( BITE .EQ. 10 .AND. LINLEN .EQ. 0 )) GOTO 20054
      GOTO 20048
20054 CONTINUE
      IF (.NOT.( BITE .EQ. 13 )) GOTO 20056
      LINE ( LINLEN + 1 ) = 0
      GOTO 20057
20056 CONTINUE
      IF (.NOT.( LINLEN .EQ. MAXLIN - 1 )) GOTO 20058
      LINE ( LINLEN + 1 ) = 0
      pplin = ( . FALSE . )
      RETURN
20058 CONTINUE
      LINLEN = LINLEN + 1
      LINE ( LINLEN ) = BITE
20059 CONTINUE
20057 CONTINUE
20055 CONTINUE
20053 CONTINUE
20051 CONTINUE
      GOTO 20048
20049 CONTINUE
10    LINLEN = 0
      LINE ( 1 ) = 0
      pplin = ( . FALSE . )
      RETURN
      END

C
      SUBROUTINE PPXLIN ( LINE, LINLEN )
C
C###############################################################################
C	This subroutine accepts a random length string of bytes LINE that
Cis LINLEN bytes long. LINLEN must be an integer. The routine transmits the
CLINE to the prom programmer and terminates the line with a CR.
C###############################################################################
      BYTE LINE ( 1 )
      CALL PPX ( LINE, LINLEN )
      CALL PPX ( 13, 1 )
      RETURN
      END

C
      SUBROUTINE PRMSTP
C
C###############################################################################
C	This routine sends a command to the prom programmer to exit the computer
Cremote control mode allowing commands to be entered from the programmer
Ckeyboard. This routine also disconnects the ISR vectors associated with
Cthe device.
C###############################################################################
      CALL PPXLIN ( 'Z', 1 )
      CALL PPSTP
      RETURN
      END

                                                                                                                                                                                                                                                                                   