C******************************************************************************
C
C      Neither First Chicago Corporation, the First National Bank of Chicago,
C nor any of its employees makes any warranty, either expressed or implied,
C assumes any legal liability, nor any responsibility for the accuracy,
C completeness or usefulness of any information, product or process disclosed.
C Neither does First Chicago Corportion, the First National Bank of Chicago,nor
C any of its employees represent that use of this material would not infringe
C privately owned rights.
C
C******************************************************************************
C
C
C
c	MAPPER.FOR   MAIN PROGRAM FOR MAPPING LARGE FSA FILES
c
C *****************************************************************************
c ******************************************************************************
c
c WRITTEN BY:  Sherman Todd, Douglas Bohrer
c       Personnel Department, The First National Bank of Chicago
c       1 First National Plaza, 22nd Floor
c       Chicago, Illinois 60670
c
c DATE:          14-SEP-81
c
C PURPOSE:  This program rearranges the fields of any fortran sequential ascii
C           file according to the user specifications.  The input and
C           output are fortran sequential ascii files.
C
c
C ******************************************************************************
c
	PROGRAM  MAPPER
	INTEGER OFMAT(512,2),AFIELD(512),ORLEN
	LOGICAL*1  IREC(512),IFILE(14),OFILE(14),OFIELD(132)
	LOGICAL*1  OREC(512),NUM(6),ERR
  500	FORMAT(14A1)
  510	FORMAT(I6)
  520	FORMAT(Q,132A1)
  530	FORMAT(255A1,129A1,128A1)
  540	FORMAT($,A1)
	TYPE *, 'INPUT FILE?'
	READ(5,500) (IFILE(I),I=1,14)
	OPEN(UNIT=1,NAME=IFILE,ACCESS='SEQUENTIAL',FORM='FORMATTED',
	1TYPE='OLD')
	TYPE *, 'INPUT RECORD LENGTH?'
	READ(5,510) IRLEN
	TYPE *,'OUTPUT FILE?'
	READ(5,500) (OFILE(I),I=1,14)
	OPEN(UNIT=2,NAME=OFILE,ACCESS='SEQUENTIAL',FORM='FORMATTED',
	1INITIALSIZE=-1, TYPE='NEW',CARRIAGECONTROL='LIST')
	TYPE *, 'OUTPUT FIELDS?'
	L=0
	K=1
	ERR=.FALSE.
  100	READ(5,520) NCHAR,(OFIELD(I),I=1,132)
	DO 200 J=1,NCHAR
	IF (K.GT.512) TYPE *,' ERROR:  THE LENGTH OF THE OUTPUT
	1 RECORD EXCEEDS THE MAXIMUM RECORD LENGTH'
	IF (K.GT.512) STOP
	IF (OFIELD(J).NE.',') GO TO 110
	IF (OFIELD(J-1).EQ.',') TYPE *,' ERROR:  TWO CONSECUTIVE
	1 COMMAS WERE ENTERED IN THE OUTPUT FIELD ENTRY'
	IF (OFIELD(J-1).EQ.',') STOP
	CALL CNVRT(L,K,NUM,OFMAT,1)
	IF (ERR) STOP
  110	IF (OFIELD(J).EQ.',') GO TO 200
  	IF (OFIELD(J).NE.':') GO TO 120
	IF (OFIELD(J-1).EQ.':') TYPE *,' ERROR:  TWO CONSECUTIVE
	1 COLONS WERE ENTERED IN THE OUTPUT FIELD ENTRY'
	IF (OFIELD(J-1).EQ.':') STOP
	CALL CNVRT(L,K,NUM,OFMAT,2)
	IF (ERR) STOP
	GO TO 200
  120	IF (OFIELD(J).EQ.' '.AND.J.EQ.NCHAR) CALL CNVRT(L,K,NUM,OFMAT,2)
	IF (ERR) STOP
	IF (OFIELD(J).EQ.' ') GO TO 200
	IF (OFIELD(J).EQ.'-'.AND.J.EQ.NCHAR) GO TO 200
	IF (OFIELD(J).LT.'0'.OR.OFIELD(J).GT.'9') TYPE *,
	1' ERROR:  ILLEGAL CHARACTER IN THE OUTPUT FIELD ENTRY'
	IF (OFIELD(J).LT.'0'.OR.OFIELD(J).GT.'9') STOP
	NUM(L+1)=OFIELD(J)
	L=L+1
	IF (J.EQ.NCHAR) CALL CNVRT(L,K,NUM,OFMAT,2)
	IF (ERR) STOP
  200	CONTINUE
	IF (OFIELD(NCHAR).EQ.'-') GO TO 100
	ORLEN=0
	DO 300 M=1,K-1
	ORLEN=OFMAT(M,2)+ORLEN
	LOC=ORLEN-OFMAT(M,2)
        DO 300 N=1,ORLEN
	AFIELD(N+LOC)=OFMAT(M,1)+N-1
  300	CONTINUE
  350	READ(1,530,END=999) (IREC(I),I=1,IRLEN)
	WRITE(2,530) (IREC(AFIELD(I)),I=1,ORLEN)
	GO TO 350
  999	CONTINUE
CLOSE(UNIT=1,DISP='SAVE')
CLOSE(UNIT=2,DISP='SAVE')
	STOP
	END
	SUBROUTINE CNVRT(L,K,NUM,OFMAT,MATCOL)
	INTEGER OFMAT(512,2)
	LOGICAL*1 NUM(6)
	IF (L.EQ.0.AND.MATCOL.EQ.1) TYPE *,' ERROR:  A COMMA WAS
	1 ENTERED IN THE OUTPUT FIELD ENTRY AND WAS NOT PRECEDED
	2 BY A FIELD VALUE'
	IF (L.EQ.0.AND.MATCOL.EQ.2) TYPE *,' ERROR:  A COLON WAS
	1 ENTERED IN THE OUTPUT FIELD ENTRY AND WAS NOT PRECEDED
	2 BY A FIELD VALUE'
	IF (L.EQ.0) ERR=.TRUE.
	IF (ERR) RETURN
	DECODE(L,10,NUM) OFMAT(K,MATCOL)
   10	FORMAT(I6)
	L=0
	IF (MATCOL.EQ.2) K=K+1
	RETURN
	END
     