/* VIRT1.C
**
** BY:  Adam Bridge
**	Multiware, Inc.
**	Box 161
**	139 G Street
**	Davis, CA 95616
**
**	(916)753-6802
**
** REV: 1281.051
**
**
*/

#include <std.h>
#include <rt11.h>
#include "virt.h"
#define R	ROOT[index]


/* F_TO_50(dblk,fn) converts a standard filename into a RADIX 50 
** representation suitable for use by the RT-11 filesystem calls.
** This fuction appears in the WHITESMITH's C manual under PDP-11
** functions. This is COPYRIGHT (C) WHITESMITHS LTD NY, NY. Permission
** granted for reproduction and non-commercial use in DECUS sub-
** mission made by telephone to Adam Bridge.
*/

VOID f_to_50(dblk,fn)
    COUNT dblk[4];	/* pointer to 4 word radix 50 file name block */
    TEXT fn[];		/* pointer to null terminated filename string */
    {
    FAST COUNT n;

    n = scnstr(fn,':');
    if (fn[n] ) 
	{
	dblk[0] = rad50(fn,n);
	fn += n + 1;
	}
    else
        dblk[0] = 0;
    n = scnstr(fn,'.');
    dblk[1] = rad50(fn,n);
    dblk[2] = rad50(fn+3,n-3);
    dblk[3] = ( fn[n] == '.' ) ? rad50(fn+n+1,lenstr(fn+n+1)): 0;
    }

/* VEXIT() is responsible for properly closing all files opened by
** the virtual array facility.  Files that are NEW or OLD are kept
** in the file system.  Files opened as SCRATCH should be removed but
** currently aren't.
*/

VOID vexit()
    {
    IMPORT COUNT error;
    IMPORT struct rt ROOT[];
    FAST COUNT i;
    COUNT code;
    PAGE_PTR p;


    for ( i = 0; i < 5; i++)
	{
	if ( ROOT[i].frst_page == NULL )
	    continue;
	for ( p = ROOT[i].frst_page; p != NULL; p = p->nxt_page) 
		if ( p->update )
			wwrite(ROOT[i].chan,p->blk_num,p->data,BLK_SIZE/2);
	if ( (code = u_close(ROOT[i].chan)) < 0) 
		{
		error = code;
		trouble();
		}
	}
    }
                                                                                                                                                                                                                                                               