#include "stdio.h"		/* PROGRAM  BACKUP.C */
				/* TRANSFERS DISK FILES TO MAGNETIC TAPE */
#define BLKF 20			/* BLKF= TAPE BLOCKING FACTOR */
int chan ;			/* TAPE CHANNEL ALLOCATED */
char buf[40][512] ;		/* DATA BUFFER .. DOUBLED BUFFERED */
				/* SECTIONS 1-20 AND SECTIONS 21-40 */
int *bpt1,*bpt2,*bpt ;		/* bpt= pointer to current buffer position */
				/* bpt1= pointer to start of current buffer section */
				/* bpt2= pointer to start of next buffer section */
int nbuf ;			/* nbuf= number disk blocks already in buffer */
int nfile, fblks ;		/* nfile= tape file number */
				/* fblks= number blocks in tape file */
int ndump;			/* ndump= number disk files written on tape */
int long tblks;		/* tblks= total number disk blocks transfered */
	char dir[20];		/* dir= array containing dir file name */

main()
{
	extern int iclose();	/* special functions */
	
	printf("**** SPECIAL TAPE BACKUP ROUTINE ****\n");
	printf("     ");
	printf("Blocking factor = %d \n\n",BLKF);

	/* get directory file name */
	printf("\nENTER : Name of directory file : ");
	gets(dir);
	printf("Directory file : %s\n",dir);

	bpt=buf[0];
	bpt1=buf[0] ;
	bpt2=buf[20] ;
	nbuf=0 ;

	nfile=0; fblks=0; ndump=0; tblks=0;
	/* open magnetic tape channel */
	if(magtpe(1,bpt)==-1)
	{	call(iclose,1,&chan); exit(0);}

	/* rewind magnetic tape */
	if(magtpe(2,bpt)==-1) exit(0);

	/* test ...read disk file then write it */
	
	ndump=1;
	readwt(dir,0);

	/* GET FILES FROM DIRECTORY */
	/* test .... multiple file read */
	multfl() ; 

	/* TAPE DUMP FINISHED .. WRITE EOT */
	magtpe(3,bpt);
	magtpe(2,bpt1);
	call(iclose,1,&chan);
}


magtpe(fun,buff)		/* MAGNETIC TAPE HANDLER */
			/* int,chan ;  REQUIRED GLOBAL VARIABLE */
int fun ;			/* fun= function called */
int *buff ;		/* buff= pointer to buffer */
{	int err ;		/* err= error flag code variable */
	int code ;		/* code= octal code used in ispfn & ispfn */
	extern int ispfn(),igetc(),lookup(),iwait() ; /* special functions */
	int ddev[4] ;		/* ddev= pointer to device name */
	char *dev ;		/* magnetic tape  MTO */
	int count ;		/* number ascii char converted to radix-50 */
	int wcnt, blk[4] ;	/* both needed in ispfn, ispfn */
	dev="MT0";
	count=3 ;
	ascr50(count,dev,&ddev[0]);	/* define device name for 'lookup' */

	/* WHAT FUNCTION HAS BEEN CALLED */
	if(fun==1)	/* OPEN TAPE CHANNEL */
	{	if((chan=call(igetc,0))==-1)
		{	printf(" TAPE CHANNEL NOT OPENNED \n"); return(-1);}
		else
		{
			if((err=call(lookup,2,&chan,ddev))!=0)
			{	printf(" LOOKUP ERROR : %d\n",err); return(-1);}
			else return(0) ;
		}
	}
	else if(fun==2)	/* REWIND MAGNETIC TAPE */
	{	code='\373' ;
		if((err=call(iwait,1,&chan))!=0)
		{	printf(" REWIND-WAIT ERROR :%d\n",err); return(-1);}
		else if((err=call(ispfn,2,&code,&chan))!=0)
		{	printf(" TAPE REWIND ERROR : %d\n",err); return(-1);}
		else return(0);
	}
	else if(fun==3)	/* WRITE EOR ON TAPE */
	{	code='\377' ;
		nfile++ ;
		if(nfile==1)printf("     file size : %5d blocks \n",fblks);
		if(nfile==2)
		{	printf("DATA FILE : %6d tape blocks \n",fblks);
			printf("            %6d data files \n",ndump);
			printf("            %6ld data blocks \n",tblks);
		}
		if(nfile==3)printf("FINISHED \n");
		ndump=0; tblks=0; fblks=0;
		if((err=call(iwait,1,&chan))!=0)
		{	printf(" EOR WRITE-WAIT ERROR :%d\n",err); return(-1);}
		else if((err=call(ispfn,2,&code,&chan))!=0)
		{	printf(" EOR WRITE ERROR :%d\n",err); return(-1);}
		else return(0);
	}
	else if(fun==4)	/* WRITE DATA BLOCK ON TAPE */
	{	code='\371'; wcnt=BLKF*256;
		fblks++;
		if((err=call(iwait,1,&chan))!=0)
		{	printf(" BLOCK WRITE-WAIT ERROR :%d\n",err);return(-1);}
		else if((err=call(ispfn,5,&code,&chan,&wcnt,buff,blk))!=0)
		{	printf(" BLOCK WRITE ERROR :%d\n",err); return(-1);}
		else return(0);
	}
	else if(fun==5)	/* SET TAPE DRIVE OFFLINE */
	{	code='\372' ;
		if((err=call(iwait,1,&chan))!=0)
		{	printf(" OFFLINE-WAIT ERROR : %d\n",err); return(-1); }
		else if((err=call(ispfn,2,&code,&chan))!=0)
		{	printf(" OFFLINE ERROR : %d\n",err); return(-1); }
		else return(0);
	}
}


readfl(open,rchan,sblk,wcnt,bufp)	/* DISK FILE READ */

		/* function returns */
		/* -1 .. if a read error occured */
		/* n  .. the number disk blocks actually read */
int open,rchan;
				/* open= flag ; 0=open , 1=not open */
				/* rchan= channel to be read */
int sblk,wcnt,*bufp;		/* sblk= starting block nmber on disk */
				/* wcnt= number words to be read */
				/* bufp= pointer to buffer */
{	extern int ireadw() ; 	/* special functions used */
	int err ;
	int blks;		/* blks= calulated value ..number blocks read */
	int nofile;
	/* TEST IF FILE IS OPEN */
	if(open==0)	/* file is open */
	{
		err=call(ireadw,4,&wcnt,bufp,&sblk,&rchan) ;
		if(err<-1)
		{	printf(" READ ERROR : %d\n",err); return(-1);}
		else if (err==-1) return(0);
		else
		{	blks=err/256 ;
		(long)	tblks += blks ;
			return(blks) ;
		}
		nofile=0;
	}
	else		/* file is not opened */
	{
		blks=wcnt/256 ; blank(bufp,blks); /* blank out buffer */
		if(nofile==0)
		{  nofile=1;
		printf("     .....Blank fill file on tape\n");
		}
	(long)	tblks+=blks;
		return(blks);
	}
}

readwt(name,code)		/* READ - WRITE FUNCTION */
char name[20];		/* name= contains file name */
int code;		/* code= flag : */
			/* if code=0 ..dump complete file to tape when */
			/*             buffer is full and at end of file */
			/* if code=n ..n blocks are to be dumped to */
			/*             tape only when buffer is full */
			/* if code=-1 .. remaining buffer is to be written */

{
	int blks ;		/* number blocks to be trans. to buffer */
	extern int ireadw() ;	/* special function */
	int wcnt, rchan, open ;	/* wcnt= number words to be read */
				/* rchan= channel number assigned */
				/* open= flag ; 0=open , 1=not open */
	int sblk,err ;		/* sblk= starting block number to be read */
	FILE *fopen(),*fp ;
	int found;		/* found= num blocks found for file */

	/* DETERMINE FILE SIZE */
	if(code==0) blks=9999 ;
	else if(code==-1) {code=0; blks=0; }
	else        blks=code ;

	/* OPEN FILE - SET VARIABLES */
	if((fp=fopen(name,"rn"))== NULL) open=1 ;
	else open=0 ;
	sblk=0 ; 
	rchan= flun(fp) ;
	found=0;

	/* WAS FILE OPENED ? */
	if(open==1)printf("     Connot open file : %s \n",name);

	/* DETERMINE NUMBER BLOCKS TO READ */
	/* calulate wcnt words to be read */
	while(blks>0)
	{
		if(blks<=(BLKF-nbuf))	/* room for complete file */
			wcnt=256*blks ;
		else			/* room for part of file */
			wcnt=256*(BLKF-nbuf) ;

	/* READ FILE - PUT IN BUFFER */
		if((err=readfl(open,rchan,sblk,wcnt,bpt))==-1)
			return(-1) ;	/*read error*/
		else			/* read OK */
		{	bpt += 256*err ;
			sblk += err ;
			nbuf += err ;
			blks-=err ;
			if(err==0)blks=0 ;
			found+=err;
			if(blks==0 && found!=code && code>0)
			{
		printf("     Missmatch file size .. file : %s \n",name);
		printf("     .....expected %d blocks \n",code);
		printf("     .....found %d blocks \n",found);
				if(code>found)
				{	blks=code-found;
					open=1 ;
				}
				else printf("     File truncated..\n");
			}
		}

	/* IS BUFFER FULL ?? */
		if(BLKF<=nbuf)		/*YES write buffer */
		{	if((err=magtpe(4,bpt1))==-1) return(-1) ;
			bpt=bpt2 ;
			bpt2=bpt1 ;
			bpt1=bpt ;
			nbuf=0 ;
		}
	}
	/* WRITE REMAINING BUFFER TO TAPE ??? */
	if(code == 0 && nbuf != 0)
	{	blank(bpt,0);
		if((err=magtpe(4,bpt1))==-1) return(-1) ;
		bpt=bpt2; bpt2=bpt1; bpt1=bpt; nbuf=0;
	}

	/* WRITE EOR ??? */
	if(code==0)magtpe(3,bpt1);

	/* CLOSE FILE */
	if(open==0)
	{
		if((err=fclose(fp))==-1)
		{	printf(" ERROR IN CLOSING FILE : %s\n",name); return(-1);}
	}
	return(0);
}

blank(bufp,code)	/* BLANK BUFFER FUNCTION */

int *bufp,code;		/* bufp= pointer to spot where blanking is to start */
			/* code= 0 ..blank to end of buffer */
			/*       n ..blank n disk blocks    */
{	
	int i,max;	/* i= counter */
			/* max= calulated nunber blocks to blank */
	if(code==0) max=256*(BLKF-nbuf);
	else        max=256*code;

	for(i=0; i<max; i++)
	{	*bufp=' ' ; bufp++; }
}

multfl()	/* GET MULTIPLE FILE NAMES */

		/*      that are to be dumpped to tape */

		/* directory format ; */
		/* file_name  number_blocks  cum_block_count  creation_date */

		/* only the file_name & number_blocks are used */
{
	char name[20];		/* indiv file name */
	char lname[20];
	char date[15];		/* date of creation */
	int long cum;		/* cum= cumulative blocks count */
	int blks, err ;		/* blks= number blocks in the file */
	char line[50] ;		/* line= temp storage of directory line */
	FILE *fopen(), *fp;

	/* OPEN DIRECTORY FILE */
	if((fp=fopen(dir,"rn"))==NULL)
	{	printf(" CANNOT OPEN DIRECTORY : %s\n",dir); return(-1);}

	/* READ DIRECTORY INTO line THEN sscanf() TO EXTRACT name & blks */
	while(fgetss(line,33,fp)!=NULL)
	{	if((err=sscanf(line,"%14s%5d%6d%7s",name,&blks,&cum,date))<0)
		break ;
	/* CALL READ/WRITE FUNCTION */
		if((err=readwt(name,blks))==-1) return(-1) ;
		ndump++;
	/* WHAT PLATTER IS BEING WRITTEN */
		if(strncmp(name,lname,4)!=0)
		{strncpy(lname,name,4);	lname[4]='\0';
		printf("Dumping files from : %4s\n",lname);
		}
	}
	/* DONE , MUST DUMP WHAT IS LEFT IN BUFFER */
	if((err=readwt(name,-1))==-1) return(-1);
}
                                                                                                                                                                                                                                                                                                                                          