vdim                    VIRTUAL ARRAYS                                  vdim

NAME
    vdim - dimension a virtual array and associate it with a file

SYNOPSIS
    BOOL vdim(name, number, dispos, f_size, d_size)
    	COUNT number, dispos, d_size;
    	LONG f_size;
    	TEXT *name;
FUNCTION
    vdim associates a virtual array refered to by number with
    a file name. dispos has values NEW, OLD, SCRATCH defined in
    VIRT.H.  A new file is created and remains upon the file system
    after the program execution is complete.  OLD is an already
    existant file that remains after execution while SCRATCH is
    a new file that is deleted upon program exit. f_size is the
    number of elements the virtual array can handle (note that it
    is a LONG value and hence can be huge) while d_size is the
    number of bytes in each data element.

RETURNS
    YES if the virtual array was properly created otherwise no.

EXAMPLE
    To create a double precision virtual array of 20,000 elements
    which already exists as a file named mydata.dat and associate it
    with virtual array #2:

    if ( vdim("mydata,dat", 2, OLD, 20000L, 8) == NO )
        {
    	
    	/* error handling routines go here */
    	
    	}
    /* normal execution progresses here */

BUGS
    You have to be careful about the filename that you pass to vdim().
    If you only pass it the name of a device then vdim will open the entire
    device as a non-file structured device giving you access to the entire
    surface, or atleast as much as you've dimensioned.  This can be nice
    but it can also be horrid as directories have a tendancy to vanish
    under such conditions.

                                                                                                                                                                                                                                                                                                                                                     