      PROGRAM SCRIP
C
C     DOUBLE PRECISION U. OF SAN DIEGO BENCHMARK.
C
C     Mods by Harry M. Murphy, AFWL, for PDP-11 and VAX-11/780
C     timing via SECNDS,  30 July 1982.
C
      DOUBLE PRECISION A,B,DA,RMS,Z
C
      DIMENSION A(16384),B(16384)
C
      WRITE (6,100)
      TZERO=SECNDS(0.0)
      N=16384
      DA=1.0D0/(N-1)
      DO 1 I=1,N
      A(I)=DA*(I-1)
 1    B(I)=0.D0
      CALL FFT2(A,B,N)
      CALL FFT2I(A,B,N)
      RMS=0.D0
      DO 2 I=1,N
      Z=A(I)-DA*(I-1)
 2    RMS=RMS+Z*Z+B(I)*B(I)
      RMS=DSQRT(RMS/N)
      WRITE(6,101)RMS
      TRUN=SECNDS(TZERO)
      WRITE (6,102) TRUN 
      STOP
  100 FORMAT (' DOUBLE PRECISION U. OF SAN DIEGO BENCHMARK')
  101 FORMAT (10X,D10.1)
  102 FORMAT (' RUN TIME =',F8.2,' SECONDS.')
      END
      SUBROUTINE FFT2(AR,AI,N)
      DOUBLE PRECISION AR,AI,TR,TI,PI,UR,UI,WR,WI,UTEMP
      DIMENSION AR(N),AI(N)
      MEX=ALOG(FLOAT(N))/.693147
      NV2=N/2
      NM1=N-1
      J=1
      DO 7 I=1,NM1
      IF(I .GE. J) GO TO 5
      TR=AR(J)
      TI=AI(J)
      AR(J)=AR(I)
      AI(J)=AI(I)
      AR(I)=TR
      AI(I)=TI
   5  K=NV2
   6  IF(K .GE. J) GO TO 7
      J=J-K
      K=K/2
      GO TO 6
   7  J=J+K
      PI=3.141592653589793238462643D0
      DO 20 L=1,MEX
      LE=2**L
      LE1=LE/2
      UR=1.0D0
      UI=0.D0
      WR=DCOS(PI/LE1)
      WI=DSIN(PI/LE1)
      DO 20 J=1,LE1
      DO 10 I=J,N,LE
      IP=I+LE1
      TR=AR(IP)*UR - AI(IP)*UI
      TI=AI(IP)*UR + AR(IP)*UI
      AR(IP)=AR(I)-TR
      AI(IP)=AI(I) - TI
      AR(I)=AR(I)+TR
      AI(I)=AI(I)+TI
  10  CONTINUE
      UTEMP=UR
      UR=UR*WR - UI*WI
      UI=UI*WR + UTEMP*WI
  20  CONTINUE
      RETURN
      END
      SUBROUTINE FFT2I(A,B,N)
      DOUBLE PRECISION A,B,ANORM,AI
      DIMENSION A(1),B(1)
      CALL FFT2(A,B,N)
      ANORM=1D0/N
      N1=1+N/2
      DO 1 I=2,N1
      NI=N-I+2
      AI=A(I)
      A(I)=A(NI)*ANORM
      A(NI)=AI*ANORM
      AI=B(I)
      B(I)=B(NI)*ANORM
 1    B(NI)=AI*ANORM
      A(1)=A(1)*ANORM
      B(1)=B(1)*ANORM
      RETURN
      END
                                                                                                                                                                                                                                                                                                                                                                                                                                                     