       PROGRAM DOSMT
C                                      05-OCT-77/20-OCT-77
C
C      AUTHOR: N. A. BOURGEOIS, JR.
C              DIGITAL SYSTEMS DIVISION 1734
C              SANDIA LABORATORIES
C              PO BOX 5800
C              ALBUQUERQUE, NM 87115
C              505-264-8088
C              FTS 475-8088
C
C      THIS SOFTWARE IS ISSUED BY SANDIA LABORATORIES, OPERATED
C      FOR THE UNITED STATES ENERGY RESEARCH AND DEVELOPMENT
C      ADMINISTRATION BY SANDIA CORPORATION.
C
C                          NOTICE
C
C      THIS SOFTWARE WAS SPONSORED BY THE UNITED STATES
C      GOVERNMENT.  NEITHER THE UNITED STATES GOVERNMENT NOR
C      THE UNITED STATES ENERGY RESEARCH AND DEVELOPMENT
C      ADMINISTRATION, NOR ANY OF THEIR EMPLOYEES, NOR ANY OF
C      THEIR CONTRACTORS, SUBCONTRACTORS, OR THEIR EMPLOYEES
C      MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR ASSUMES ANY
C      LEGAL LIABILITY OR RESPONSIBILITY FOR THE ACCURACY,
C      COMPLETENESS OR USEFULNESS OF ANY INFORMATION,
C      APPARATUS, PRODUCT OR PROCESS DISCLOSED, OR REPRESENTS
C      THAT ITS USE WOULD NOT INFRINGE PRIVATELY OWNED RIGHTS.
C
C      THIS WORK WAS SPONSORED AND FUNDED BY:
C          BASE AND INSTALLATION SECURITY SYSTEM PROGRAM OFFICE
C          ELECTRONIC SYSTEMS DIVISION
C          AIR FORCE SYSTEMS COMMAND
C          HANSCOM AIR FORCE BASE, MA 01731
C
C
C      TABLE OF CONTENTS
C          DESCRIPTION             2
C          USER INSTRUCTIONS       2
C          DATA ASSIGNMENTS        3
C          FORTRAN PROGRAM         4
C      DESCRIPTION                     05-OCT-77/19-OCT-77
C
C      THIS PROGRAM READS RT-11 FILES AND WRITES THEM OUT ON
C      9-TRACK MAGNETIC TAPE IN DOS/BATCH FORMAT.  MORE THAN
C      ONE FILE MAY BE WRITTEN TO THE TAPE.  HOWEVER, EACH
C      TIME THE PROGRAM IS ENTERED THE FIRST FILE IS STARTED
C      FROM THE LOGICAL BEGINNING-OF-TAPE (BOT) OR LOAD
C      POINT (LD PT).
C
C      THE SEQUENCE OF EVENTS IS AS FOLLOWS:
C            1.  A MESSAGE IS PRINTED ASKING FOR THE TAPE TO BE
C                MOUNTED.
C            2.  THE TAPE IS REWOUND TO BOT.
C            3.  A MESSAGE IS PRINTED REQUESTING THE FILE
C                SPECIFICATION.
C            4.  THE FILE IS OPENED AND THE LABEL RECORD IS
C                BUILT AND WRITTEN.
C            5.  THE FILE IS TRANSFERED TO THE TAPE ONE RECORD
C                OR BLOCK AT A TIME.
C            6.  THREE EOF'S ARE WRITTEN AND THE TAPE IS
C                BACKSPACED OVER THE LAST TWO EOF'S.
C            7.  THE INPUT FILE IS CLOSED AND THE INPUT DEVICE
C                HANDLER IS RELEASED.
C            8.  THE PROGRAM THEN LOOPS BACK TO REQUEST THE
C                NEXT FILE SPECIFICATION.
C
C      FOR A DESCRIPTION OF THE SUBROUTINE "EXTMT" REFER TO:
C            N. A. BOURGEOIS, JR., "A GENERAL PURPOSE MAGNETIC
C            TAPE HANDLER", SAND77-1492, SANDIA LABORATORIES,
C            ALBUQUERQUE, NM.
C
C
C      USER INSTRUCTIONS               05-OCT-77/20-OCT-77
C
C      COMPILER COMMAND STRING:
C            DOSMT[,LP:]<DOSMT/L/U/W
C      ASSEMBLER COMMAND STRING:
C            EXTMT[,LP:]<TT:,SY:EXTMT/C/N:TTM
C            CHANGE=60000
C            ^Z^Z
C      LINKER COMMAND STRING:
C            DOSMT[,LP:]<DOSMT,EXTMT,SYSLIB/A/F
C      MONITOR COMMAND STRING:
C            R DOSMT
C
C      NOTE:  THE ITEMS CONTAINED IN SQUARE BRACKETS ARE OPTIONAL.
C      DATA ASSIGNMENTS                05-OCT-77/18-OCT-77
C
C      DOS/BATCH MT LABEL RECORD
C      	WORD #   CONTENT      COMMENT   LABEL()
C      	-        DEV          RAD50     16
C      	1-2      FILNAM       RAD50     17-18
C      	3        EXT          RAD50     19
C      	4        UIC          1,1       20
C      	5        PROTECTION   155       21
C      	6        DATE         0         22
C      	7        NOT USED     0         23
C
       DIMENSION IDATA(256)
       DIMENSION IEXT(4)
       DIMENSION LABEL(39)
C 
       DATA IEXT /0,0,0,0/
       DATA IWORD4 /257/
       DATA IWORD5 /155/
       DATA IWORD6 /0/
       DATA IWORD7 /0/
C
1      FORMAT (' MOUNT THE TAPE ON 9-TRACK MT0:')
2      FORMAT (' ENTER THE DEV:FILNAM.EXT'/' ')
9      FORMAT (I6)
C      FORTRAN PROGRAM                 06-OCT-77/20-OCT-77
C
C      ASK FOR TAPE MOUNT
       TYPE 1
       PAUSE ' PRESS RETURN TO PROCEED'
C
C      REWIND THE TAPE
       CALL EXTMT(7)
C
C      ASK FOR & ENTER THE FILE SPECIFICATION
100    TYPE 2
       I=ICSI(LABEL,IEXT,,,0)
       IF (I.NE.0) GOTO 100
C
C      OPEN THE FILE
       ICHAN=IGETC()
       IF (ICHAN.LT.0) STOP ' DOSMT: IGETC ERROR'
       I=IFETCH(LABEL(16))
       IF (I.NE.0) STOP ' DOSMT: IFETCH ERROR'
       IBLOCK=LOOKUP(ICHAN,LABEL(16))
       IF (IBLOCK.LT.0) STOP ' DOSMT: LOOKUP ERROR'
C
C      BUILD & WRITE THE LABEL RECORD
       LABEL(20)=IWORD4
       LABEL(21)=IWORD5
       LABEL(22)=IWORD6
       LABEL(23)=IWORD7
       CALL EXTMT(2,14,LABEL(17))
C
C      TRANSFER THE FILE TO THE TAPE
       K=0
       DO 110 L=1,IBLOCK
           I=IREADW(256,IDATA,K,ICHAN)
           IF (I.LT.0) STOP ' DOSMT: IREADW ERROR'
           CALL EXTMT(2,512,IDATA)
           K=K+1
110    CONTINUE
C
C      WRITE EOF'S & BACKSPACE
       CALL EXTMT(3)
       CALL EXTMT(3)
       CALL EXTMT(3)
       CALL EXTMT(5,2)
C
C      CLOSE THE FILE & LOOP BACK FOR MORE
       CALL CLOSEC(ICHAN)
       I=IFREEC(ICHAN)
       IF (I.NE.0) STOP ' DOSMT: IFREEC ERROR'
       GOTO 100
C
C      LOGICAL & PHYSICAL END OF PROGRAM
       END
                         