/*+
 * VOID tfrres(field, result, itrim)
 *     TEXT  *field, *result;
 *     BOOL  itrim;
 *
 * Description  : Routine to return the contents of one or all field(s)
 *                from the field copy record to the application program
 *
 * Arguments    : field  = STRING containing the field name, or null-string
 *                result = STRING containing the contents of the field
 *                itrim  = INTEGER 0: no trim of trailing spaces
 *                                 1: trim if FIELD is not empty
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.1      Date : 28-jan-83
 *
 * Module name  : TFRRES.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *  description : R. Beetz             V1.1
 *                ITRIM argument added
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrres.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrres(field, result, itrim)
    TEXT  *field, *result;
    BOOL  itrim;

    {
    IMPORT TFRCOM t;

#include <upddef.h>

    FAST COUNT i;

    COUNT lf;
    COUNT *pf;

    pf = &t.frec;
/*
 *    search update field with specified name
 */
    *result = NULL;
    lf = lenstr(field);
    if(t.nrfufr)
        {
        scvtlu(field);
        for(i = t.nrfufr; i <= t.nrlufr; ++i)
            {
            tfrru(i, "VAR");        /* read update field record */
            if(!lf  ||  cmpstr(field, &pf->updfld))
                {
                tfrru(i, "FCR");    /* read update field copy record */
                cpystr(&result[lenstr(result)], &t.fcr[pf->npfcr], NULL);
                if(lf)
                    {
                    break;
                    }
                }
            }
        if(lf  &&  !cmpstr(field, &pf->updfld))
            {
            error("TFRRES", "-Field not found");
            }
        }
/*
 *   trim if required
 */
    if(lf  &&  itrim)
        {
        for(i = lenstr(result)-1; result[i] == ' '; result[i--] = NULL);
        }
    }
                                                                       