/*+
 * VOID tfropn(file, lunit)
 *     TEXT  *file;
 *     COUNT lunit;
 *
 * Description  : Routine to open a TFR-library file
 *
 * Arguments    : file   = STRING containing the file-name without extension
 *                lunit  = INTEGER logical unit number
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : TFROPN.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfropn.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

GLOBAL TFRCOM t {0};               /* TFR common block */

VOID tfropn(file, lunit)
    TEXT  *file;
    COUNT lunit;

    {
    IMPORT TFRCOM t;

/*
 *    general info record 1
 *       VNR			! version number
 *       NRFSFR			! rec.nr. first form
 *       HOMSTR			! esc.seq: home position
 *       CLRSTR			! esc.seq: clear screen
 *       ERLSTR			! esc.seq: erase line
 *       NATSTR			! esq.seq: reset video attributes
 *
 *    general info record 2
 *       HERPOS			! esc.seq: position error/help message
 *       ERRATT			! esq.seq: video attributes error message
 *       HLPATT			! esq.seq: video attributes help message
 *
 */

    LOCAL TEXT prog[] = "TFROPN";

    TEXT  filnam[16], vnr[4], buf[40];
    COUNT nrfsfr;

/*
 *    generate complete file-name and open
 */
    cpystr(filnam, file, NULL);
    cpystr(&filnam[scnstr(filnam, '.')], ".FEX", NULL);
    if(copen(lunit, filnam) < 0)
        {
        error(prog, "-Error opening TFR-library file");
        }
/*
 *    read general info records for initialization
 */
    t.maxbuf = 40;
    rcread(lunit, 1, t.maxbuf, buf);
    cpybuf(vnr, buf, 4);          /* assign vnr */
    cpybuf(&nrfsfr, buf+4, 2);    /* assign nrfsfr */
    cpybuf(&t.homstr, buf+6, 18); /* assign homstr, clrstr, erlstr, natstr */
    if(!cmpbuf(vnr, "V1.0", 4))
        {
        error(prog, "-Invalid version of TFR-library file");
        }
    rcread(lunit, 2, t.maxbuf, buf);
    cpybuf(&t.herpos, buf, 24);   /* assign herpos, erratt, hlpatt */
    t.iscr = 5;
    t.nunit = lunit;
    t.nrnxfr = nrfsfr;
    }
                                                                                                                                                                                                                                                                                                                                                                                                                                     