/*+
 * VOID swrite(unit, cc, str1, str2, ..., strn, NULL)
 *    COUNT unit;
 *    TEXT  *cc, *str1;
 *
 * Description  : Write to unit the concatenated strings STR1 to STRn using
 *                the FORTRAN control characters CC
 *
 * Arguments    : UNIT   = unit number to write to (optional default=5)
 *                CC     = FORTRAN carriagecontrol string (eg.' ','+$','$')
 *                         (optional default=' ')
 *                STRn   = STRINGs to write (optional)
 *                NULL   = 0 end of string list indicator
 * Author       : R.Beetz
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 * Version      : V1.0      Date : 26-oct-82
 *
 * Module name  : SWRITE.MAC
 *
 * Package      : RT11-LIBRARY
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : swrite.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>

VOID swrite(unit, cc, str1)
    COUNT unit;
    TEXT  *cc, *str1;

    {
    LOCAL TEXT  nulstr[] = "";

    TEXT  **p;                     /* pointer to strings to be written */
    TEXT  *pstr;
    TEXT  cc1[2], cc2;

    if(cc[0] == 0)
        {
        cc1[0] = ' ';
        cc2 = ' ';
        }
    else if(cc[0] == '$')
        {
        cc1[0] = ' ';
        cc2 = '$';
        }
    else if(cc[1] == '$')
        {
        cc1[0] = cc[0];
        cc2 = cc[1];
        }
    else
        {
        cc1[0] = cc[0];
        cc2 = ' ';
        }
    p = &str1;                  /* point to list of strings to write */
    cc1[1] = '$';               /* cc2 for all but last string */
    do
        {
        if(*p == NULL)
            {
            pstr = nulstr;     /* if no string */
            }
        else
            {
            pstr = *(p++);    /* point to string to write,
                                  inc pointer to point to next string write */
            }
        if(*p == NULL)
            {
            cc1[1] = cc2;       /* cc2 for last string */
            }
        swrits(unit, cc1, pstr);
        cc1[0] = '+';           /* cc1 for all but first string */
        }
    while(*p);
    }
