/*+
 * VOID mprmen(file, lunit)
 *     TEXT  *file;
 *     COUNT lunit;
 *
 * Description  : Main routine of the MPR-subroutine package
 *                Opens file, reads general info records, and controls menu
 *
 * Arguments    : file   = STRING containing the file-name without extension
 *                lunit  = INTEGER logical unit number
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 * Version      : V1.2      Date : 10-feb-1983
 *
 * Module name  : MPRMEN.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *  description : T.Pijl               V1.1
 *                Possibility to return to previous level in FSB function
 *                F.A.Minkema          V1.2
 *                Menu processing control provided by subroutine MPRMN
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprmen.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>
#include <mprgbl.h>

VOID mprmen(file, lunit)
    TEXT  *file;
    COUNT lunit;

    {
/*
 *   general info record 1
 *       VNR			! version number
 *       NRMMR			! rec.nr. of main menu
 *       CLRSTR			! esc.seq: clear screen
 *       ERLSTR			! esc.seq: erase line
 *       CLRVAT			! esc.seq: clear video attributes
 *       FLSVAT			! esc.seq: function-list key video attributes
 *
 *   general info record 2
 *       LMAR			! left margin text lines
 *       FNPPOS			! esc.seq: position 'Function:'-text
 *       FNGPOS			! esc.seq: position to get command string
 *       FLSPOS			! esc.seq: start position of function-list
 *       MESPAT			! esc.seq: pos. & video-attr. messages
 *
 *   general info record 3
 *       GENVAT			! esc.seq: general header video attributes
 *       GENLAT			! esc.seq: general header line attributes
 *       MENPAT			! esc.seq: menu header pos. & line attributes
 *
 */
    VOID  rcread(), swrite(), mprmn();
    COUNT copen();

    IMPORT MPRCOM m;

    LOCAL TEXT prog[] = "MPRMEN";

    TEXT  buf[40], vnr[4], tmp;
    COUNT ipcl;

/*
 *   generate complete file-name and open
 */
    cpystr(&m.mprfil, file, NULL);
    cpystr(&m.mprfil[scnstr(&m.mprfil, '.')], ".MEX", NULL);
    if(copen(lunit, &m.mprfil) < 0)
        {
        error(prog, "-Error opening MPR-library file");
        }
/*
 *    read general info records for initialization
 */
    m.maxbuf = 40;
    rcread(lunit, 1, m.maxbuf, buf);

    cpybuf(vnr, buf, 4);     /* assign vnr */
    cpybuf(&m.nrmmr, buf+4, 2);    /* extract short from input line */
    cpybuf(&m.clrstr, buf+6, 26); /* assign clrstr, erlstr, clrvat, flsvat */
    if(!cmpbuf(vnr, "V1.0", 4))
        {
        error(prog, "-Invalid version MPR-library file");
        }
    rcread(lunit, 2, m.maxbuf, buf);
    cpybuf(&m.lmar, buf, 2);        /* extract short from input line */
    cpybuf(&m.fnppos, buf+2, 38);   /* assign fnppos, fngpos, flspos, mespat*/
    rcread(lunit, 3, m.maxbuf, buf);
    cpybuf(&m.genvat, buf, 26);     /* assign genvat, genlat, menpat */
    m.nunit = lunit;
    m.iscr = 5;
    m.mstack = 7;
    for(tmp = 0; tmp <= m.mstack; m.istack[tmp] = 0, ++tmp);
    m.ibtflg = FALSE;
    m.imesfl = FALSE;
    m.ifunct = 0;
    m.nrnrcm = 0;
    m.inrec = m.nrmmr;
    ipcl = 1;
/*
 *    control menu processing
 */
    mprmn(ipcl);
    swrite(m.iscr, "+$", &m.clrstr, &m.clrvat, NULL);
    }
                                                                                                                                                                                                                                                                                                            