/*+
 * VOID inpmod (modstr)
 *    TEXT *modstr;
 *
 * Description  : Set mode for terminal input
 *
 * Arguments    : modstr = STRING with keywords seperated by a '+'
 *                  keywords :   WAIT   : wait for character typed
 *                             NOWAIT   : do not wait for character typed
 *                             NORMAL   : same as 'ECHO+WAIT'
 *                               ECHO   : echo characters typed
 *                             NOECHO   : do not echo characters typed
 *                                        (only CTRL-C and CTRL-O are handled
 *                                         normallly)
 *                               LOWER  : lower case characters are accepted
 *                             NOLOWER  : lower case characters are converted
 *                                        to upper case
 *
 *                   NB. for input with routine IGTKEY or IGTCHR
 *                         NOECHO +   WAIT = returns after each character and
 *                                           not when buffer is empty
 *                         NOECHO + NOWAIT = returns after each character or
 *                                           when buffer is empty
 *                         ECHO   +   WAIT = returns after CR
 *                         ECHO   + NOWAIT = returns after CR or
 *                                           when buffer is empty
 *                       for normal line input the WAIT setting has no effect
 *
 * Author       : R. Beetz
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 23-dec-82
 *
 * Module name  : INPMOD.FOR
 *
 * Package      : RT11-LIBRARY
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : inpmod.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/

#include <local.h>

VOID inpmod (modstr)
    TEXT *modstr;

    {
    VOID  scvtlu(); 
    COUNT index();

    scvtlu(modstr);
    if(fcall(&index, 2, modstr, "NORMAL"))
        {
        JSW = JSW & 0167677;
        }
    else
        {
        if(fcall(&index, 2, modstr, "NOWAIT"))
            {
            JSW = JSW | 0100;
            }
        else if(fcall(&index, 2, modstr, "WAIT"))
            {
            JSW = JSW & 0177677;
            }
        if(fcall(&index, 2, modstr, "NOECHO"))
            {
            JSW = JSW | 010000;
            }
        else if(fcall(&index, 2, modstr, "ECHO"))
            {
            JSW = JSW & 0167777;
            }
        }
    if(fcall(&index, 2, modstr, "NOLOWER"))
        {
        JSW = JSW & 0137777;
        }
    else if(fcall(&index, 2, modstr, "LOWER"))
        {
        JSW = JSW | 040000;
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        