/*+
 * METACH igtkey()
 *
 * Description  : Checks the terminal input buffer if a key has been pressed.
 *
 * Arguments    : Function value
 *                 = 0 if no key is pressed,
 *                 = ASCII value of key pressed,
 *                   If KEYPAD key is pressed =
 *                    -1 = '1' , -7  = '7'   , -13 = 'PF3'    , -19 = '^'
 *                    -2 = '2' , -8  = '8'   , -14 = 'PF4'    , -20 = 'v'
 *                    -3 = '3' , -9  = '9'   , -15 = '-'      , -21 = '<'
 *                    -4 = '4' , -10 = '0'   , -16 = ','      , -22 = '>'
 *                    -5 = '5' , -11 = 'PF1' , -17 = 'ENTER'
 *                    -6 = '6' , -12 = 'PF2' , -18 = '.'
 *                  NB. An escape can not be detected. If a CR is found the
 *                      next character in the buffer is lost (normally the LF
 *                      added by the operating system)
 *
 * Author       : T.Pijl
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 7-dec-82
 *
 * Module name  : IGTKEY.FOR
 *
 * Package      : RT11-LIBRARY
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : igtkey.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>

METACH igtkey()

    {
    METACH igtchr();

    METACH key;
    COUNT  i;

    key = igtchr();                         /* get 1st char from buffer */
    if(key < 0)
        {
        return(key)
        }
    if(key == 033)                          /* is it <ESC>? */
        {
        key = igtchr();                    /* get 2nd char from buffer */
        if(key < 0)
            {
            return(key);
            }
        else if(key == 'O')               /* is it O ? */
            {
            key = igtchr();             /* get 3rd key from buffer */
            if(key < 0)
                {
                return(key);
                }
            else if(key >= 'P'  &&  key <= 'S')
                {
                return(69 - key);
                }
            else if(key >= 'q'  &&  key <= 'y')
                {
                return(112 - key);
                }
            else
                {
                switch(key)
                    {
                case 'p':
                    return(-10);
                case 'n':
                    return(-18);
                case 'M':
                    return(-17);
                case 'l':
                    return(-16);
                case 'm':
                    return(-15);
                    }
                }
            }
        
        else if(key == '[')
            {
            key = igtchr();                 /* get 3rd key from buffer */
            switch(key)
                {
            case 'A':
                return(-19);
            case 'B':
                return(-20);
            case 'D':
                return(-21);
            case 'C':
                return(-22);
                }
            }
        }
    else if(key == '\r')
        {
        i = igtchr();                        /* get rid of <LF> */
        }
    return(key);
    }

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 