/*+
 * VOID cwrite(unit, buf, len)
 *    COUNT  unit, len;
 *    TEXT   *buf;
 *
 * Description  : This routine writes character output on
 *                simulated fortran logical unit number.
 *
 * Arguments    : unit   = unit number to write to.
 *                text   = buffer to be sent.
 *                len    = number of bytes to send.
 *
 * Author       : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : cwrite.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <fortio.h>

VOID cwrite(unit, buf, len)
    COUNT  unit, len;
    TEXT   *buf;

    {
    IMPORT FIO fortio[NFCHNL];

    --unit;
    if(len == 0)
        {
        return(0);
        }
    else if(fortio[unit]._fd == -1)
        {
        putlin(buf, len);
        putch(-1);
        }
    else
        {
        putl(&fortio[unit], buf, len);
        putc(&fortio[unit], -1);
        }
    }
                                                                                                                                                                                                                                                                                                                      