C NAME OF PGRM: LOGARITHMIC GRAPHICAL SCALING SUBROUTINE  (SCALOG)
C AUTHOR:       CHARLES E. COHN, ARGONNE NATIONAL LABORATORY
C PURPOSE:      TO SCALE ARBITRARY DATA TO BE PLOTTED LOGARITHMICALLY
C               IN A WHOLE NUMBER OF DECADES.
CCCC
C     CALLING STATEMENT "CALL SCALOG(X,N,S,IMAX,NDEC,XMIN,DX)"
C     WHERE X IS A SINGLE-PREC. FLT.PT.ARRAY CONTAINING THE BASE-10
C             LOGARITHMS OF THE DATA TO BE SCALED. ON EXIT, EACH ELEMENT
C             IS REPLACED BY ITS GRAPH COORDINATE IN INCHES.
C           N IS LENGTH OF X
C           S IS SIZE OF GRAPH, INCHES
C     (THE FOLLOWING QUANTITIES ARE CALCULATED BY THE ROUTINE)
C           IMAX IS THE POWER OF TEN CORRESPONDING TO THE BOUNDARY OF
C                THE GRAPH AWAY FROM THE ORIGIN
C           NDEC IS THE NUMBER OF DECADES SPANNING THE DATA
C           XMIN IS THE VALUE OF THE LOGARITHM AT THE ORIGIN
C           DX IS THE CHANGE IN LOGARITHM PER INCH ON THE GRAPH
      SUBROUTINE SCALOG(X,N,S,IMAX,NDEC,XMIN,DX)
      DIMENSION X(N)
      B=X(1)
      A=B
      DO10I=2,N
      A=AMIN1 (A,X(I))
   10 B=AMAX1 (B,X(I))
      IMAX=B
      IF(B)1,1,2
    2 IMAX=IMAX+1
    1 NDEC=A
      IF(A)3,4,4
    3 NDEC=NDEC-1
    4 XMIN=NDEC
      NDEC=IMAX-NDEC
      DX=FLOAT (NDEC)/S
      DO20I=1,N
   20 X(I)=(X(I)-XMIN)/DX
      RETURN
      END
                                                                                                                                                                              